/*	randomdot.c is a program to convert a ppm image file that contains
|*	the simple structure of an image to be made 3d.  I generate this
|*	file by exporting IslandPaint as sun raster.  Then I run
|*	rasttopnm to get the ppm.  (rasttopnm is in the pbmplus distribution)
|*	I then run this prog with:
|*	randomdot < infile > outfile
|*
|*	So what is this for anyway?  This creates what is know as a
|*	Single Image Random Dot Sterogram.  Say What?  I you unfocus your
|*	eyes and stare at the image (right side up) long enough all will
|*	become clear.  Times for focusing on the new image vary between
|*	1 min to 15 min.  Have patience and you will be rewarded.
|*
|*	Acknowledgments:
|*	Pentica Systems INC In-circuit Emulators
|*	One Kendall Square
|*	Building 200
|*	Cambridge, MA 02139
|*	for suppling the pamphlet within which I learned the miracle of
|*	Random Dot Sterograms.
|*
|*	Stero World Magazine.
|*	For running 2 articles about random dot sterograms in their
|*	March/April 1990
|*	and some other month i can't find right no.
|*
|*	And Tom (not sure of his last name) at PENTICA for writing some
|*	vga display code.  I served well as an example of the algorithm.
|*	without which this would not have been written.
|*
|*	History:
|*	1/23/92:	started trying to read the rasterfile.
|*	1/24/92:	used ppm instead.  finished first test at 11:30 pm.
|*	1/27/92:	now supports multiple levels of depth.
|*
|*	More to come i promise.  It will support multiple levels of depth.
|*	send comments, corrections, improvements, suggestions, pizza crusts,
|*	etc... to 
|*	long1@eng.auburn.edu
|*
|*	Also I must thank my boss for not sacking me for wasting my time
|*	with this.
*/

#include <stdio.h>
#define PPM_MAGIC6 "P6"
#define VALID_OPS "s:d:"
#define USAGE_MSG "Usage: %s [-s int (10-100)] [-d int (5-10)]\n",argv[0]

#ifndef lint
static char SCCS_id[] = "%Z%%M%  %I%  %G%    Auburn University Engineering";
#endif

/*	My interpretation of the PPM standard header
*/
struct ppm {
	    char magic[2];
	    int width;
	    int height;
	    int maxrgb;
	    };

/*	My personal pixel structure
*/
struct image_pixel {
	    unsigned char r;
	    unsigned char g;
	    unsigned char b;
	    };

struct ppm headerin;
int strip_width,depth_factor;

void process_args();
void read_image();
void write_image();
void build_strip();
void make_3d();
int foreground();

main (argc,argv)
int argc;
char *argv[];
{
   FILE *in,*out;
   struct image_pixel *image;

   in=stdin;
   out=stdout;
   strip_width=50;
   depth_factor=15;

   process_args(argc,argv);

   fscanf(in,"%s",headerin.magic);
   if( strcmp(headerin.magic,PPM_MAGIC6) ) 
      fprintf(stderr,"Fatal:  PPM magic %s is not yet supported.\n",headerin.magic),exit(-3);
   fscanf(in,"%d",&headerin.width);
   fscanf(in,"%d",&headerin.height);
   fscanf(in,"%d ",&headerin.maxrgb);
   fprintf(stderr,"Size of input image is %dx%d\n",headerin.width,
	   headerin.height,headerin.maxrgb);
   if ( !(image = (struct image_pixel *)calloc((unsigned) headerin.width*headerin.height,
	    (unsigned) sizeof(struct image_pixel))) )
	    fprintf(stderr,"Fatal: Could not calloc needed storage!!\n"),exit(-2);

   fprintf(stderr,"Using a Strip of %d and a Depth of %d\n",strip_width,depth_factor);
   read_image(in,image,headerin.width,headerin.height);
   build_strip(image,strip_width,headerin.width,headerin.height);
   make_3d(image,strip_width,depth_factor,headerin.width,headerin.height);
   write_image(out,image,headerin.width,headerin.height);
   cfree(image);
   exit(0);
}

void process_args(argc,argv)
int argc;
char *argv[];
{
   extern char *optarg;
   extern int   optind;
	  int   flag;

   while (( flag=getopt(argc,argv,VALID_OPS)) != -1)
   switch ( flag )
   {
      case 's':
	 strip_width = atoi(optarg);
	 break;
      case 'd':
	 depth_factor = atoi(optarg);
	 break;
      default:
	 fprintf(stderr,USAGE_MSG);
	 exit(1);
      break;
   }
}

/* 	Read_Image reads from an already open data file into an
|*	array of image_pixel structures.
|*	PARAMETERS:
|*	file_ptr:		A pointer to an open file that has been read
|*				past the header information. ( IN OUT)
|*	image_ptr:		A pointer to an already calloc area of memory,
|*				this will hold the image. ( IN OUT)
|*	width:			The images width. (IN)
|*	height:			The images height. (IN)
|*	RETURNS:
|*	nothing
*/

void read_image(file_ptr,image_ptr,width,height)
FILE *file_ptr;
struct image_pixel *image_ptr;
int width,height;
{
   int x,y;
   struct image_pixel tmp;

   for(y=0;y<height;y++)
   {
      for(x=0;x<width;x++)
      {
	 if ( !fscanf(file_ptr,"%c%c%c",&(tmp.r),&(tmp.g),&(tmp.b)) )
	    fprintf(stderr,"Fatal: Error reading image data!\n"),exit(-3);
	 image_ptr[x+y*(width)]=tmp;
      }
   }
}

/*	Build_Strip is used to create random column of dots down the 
|*	right side of the image.  I call this the 3d seed.
|*	PARAMETERS:
|*	image_ptr:		A pointer to the image array ( IN OUT )
|*	width:			width of 3d seed ( IN )
|*	image_width:		The width of the image to be converted ( IN )
|*	image_height:		The number of rows in the column ( IN )
*/

void build_strip(image_ptr,width,image_width,image_height)
struct image_pixel *image_ptr;
int width,image_width,image_height;
{
   int x,y;
   struct image_pixel tmp;
   extern rand();

   for(y=0;y<image_height;y++)
   {
      for(x=0;x<width;x++)
      {
	 if (rand()%3)
	    {
	    tmp.r=254;
	    tmp.g=254;
	    tmp.b=254;
	    }
	 else
	    {
	    tmp.r=0;
	    tmp.g=0;
	    tmp.b=0;
	    }
	 image_ptr[x+y*image_width]=tmp;
      }
   }
}

/*	Make_3d is the meat of the program.  It decides wether the current
|*	pixel is in the forground.  If so look in the previous column + shift
|*	for the color value.
|*	PARAMETERS:
|*	image_ptr:		The pointer to the image to be processed(IN OUT)
|*	width:			The column width of the strip (IN)
|*	shift:			The value used to compute the pixel placment(IN)
|*	image_width:		The width of the image. (IN)
|*	image_height:		The height of the image. (IN)
|*	RETURNS:
|*	nothing
*/

void make_3d(image_ptr,width,shift,image_width,image_height)
struct image_pixel *image_ptr;
int width,shift,image_width,image_height;
{
   int x,y;
   struct image_pixel tmp;

   for(y=0;y<image_height;y++)
   {
      for(x=width;x<image_width;x++)
      {
	 tmp = image_ptr[x-width+foreground(image_ptr,x,y,image_width,shift)+y*image_width];
	 image_ptr[x+y*image_width]=tmp;
      }
   }
}

/*	Foregournd determines the depth of the current pixel.  presently this
|*	this is olny 0 or 1.  In the future this will return a range of values
|*	which will be used to compute the shift offset in make_3d.
|*	PARAMETERS:
|*	image_ptr:		Pointer to the image array (IN)
|*	x:			x coord of point of intreset (IN)
|*	y:			y coord of point of intreset (IN)
|*	image_width:		the image witdh (IN)
|*	RETURNS:
|*	a value between 0 and depth_factor: this is computed by taking the
|*	average rgb value and making it a percent of the total depth. 
|*	it is ordered such that dark colors are farther out of the page 
|*	than lighter ones.
*/

int foreground(image_ptr,x,y,image_width,shift)
struct image_pixel *image_ptr; 
int x,y,image_width,shift;
{
   struct image_pixel tmp;
   float	depth;

   tmp = image_ptr[x+y*image_width];
   depth = (float)shift-(float)shift*((float)(tmp.r+tmp.g+tmp.b)/3.0)/(float)headerin.maxrgb;
   return((int)depth);
}

/*      Read_Image reads from an already open data file into an
|*      array of image_pixel structures.
|*      PARAMETERS:
|*      file_ptr:               A pointer to an open file to write the output
|*				to (ppm) (IN OUT)
|*	image_ptr:		A pointer to the image array for writing 
|*				the output from. (IN)
|*      width:                  The images width. (IN)
|*      height:                 The images height. (IN)
|*      RETURNS:
|*      nothing
*/

void write_image(file_ptr,image_ptr,width,height)
FILE *file_ptr;
struct image_pixel *image_ptr;
int width,height;
{
   int x,y;
   struct image_pixel tmp;

   fprintf(file_ptr,"%s\n",PPM_MAGIC6);
   fprintf(file_ptr,"%d %d\n",width,height);
   fprintf(file_ptr,"%d\n",255);

   
   for(y=0;y<height;y++)
   {
      for(x=0;x<width;x++)
      {
	 tmp=image_ptr[x+y*(width)];
	 if ( !fprintf(file_ptr,"%c%c%c",tmp.r,tmp.g,tmp.b) )
	    fprintf(stderr,"Fatal: Error writing new image data!\n"),exit(-3);
      }
   }
}
