/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SeedGenerator;
import java.util.Random;

public class SecureRandom
extends Random {
    private byte[] state;
    private MessageDigest digest;
    private static SecureRandom generatorGenerator;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;

    public SecureRandom() {
        this(SecureRandom.nextSeed());
    }

    private static synchronized byte[] nextSeed() {
        if (generatorGenerator == null) {
            generatorGenerator = new SecureRandom(SecureRandom.getSeed(20));
        }
        byte[] byArray = new byte[20];
        generatorGenerator.nextBytes(byArray);
        return byArray;
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        this.setSeed(byArray);
    }

    public synchronized void setSeed(byte[] byArray) {
        if (this.state != null) {
            this.digest.update(this.state);
        }
        this.state = this.digest.digest(byArray);
    }

    public void setSeed(long l) {
        if (l != 0L) {
            this.setSeed(SecureRandom.longToByteArray(l));
        }
    }

    public synchronized void nextBytes(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.randomBytes == null || this.randomBytesUsed == this.randomBytes.length) {
                this.digest.update(this.state);
                this.randomBytes = this.digest.digest(SecureRandom.longToByteArray(this.counter++));
                this.randomBytesUsed = 0;
            }
            byArray[n2++] = this.randomBytes[this.randomBytesUsed++];
        }
    }

    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.nextBytes(byArray);
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 8) + (byArray[n4] & 0xFF);
            ++n4;
        }
        return n3 >>> n2 * 8 - n;
    }

    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)SeedGenerator.genSeed();
            ++n2;
        }
        return byArray;
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)l;
            l >>= 8;
            ++n;
        }
        return byArray;
    }
}

