/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class X509Key
implements PublicKey {
    protected AlgorithmId algid;
    protected byte[] key;
    private byte[] encodedKey;

    protected X509Key() {
    }

    private X509Key(AlgorithmId algorithmId, byte[] byArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.key = byArray;
        this.encode();
    }

    public static X509Key parse(DerValue derValue) throws IOException {
        X509Key x509Key;
        if (derValue.tag != 48) {
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
        try {
            x509Key = X509Key.buildX509Key(algorithmId, derValue.data.getBitString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("subject key, " + invalidKeyException.toString());
        }
        if (derValue.data.available() != 0) {
            throw new IOException("excess subject key");
        }
        return x509Key;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static String getSunProperty(String string) {
        Provider provider = Security.getProvider("SUN");
        return provider.getProperty(string);
    }

    static X509Key buildX509Key(AlgorithmId algorithmId, byte[] byArray) throws IOException, InvalidKeyException {
        String string = X509Key.getSunProperty("PublicKey.X.509." + algorithmId.getName());
        if (string == null) {
            string = "sun.security.x509.X509Key";
        }
        try {
            Class clazz = Class.forName(string);
            Object object = clazz.newInstance();
            if (object instanceof X509Key) {
                X509Key x509Key = (X509Key)object;
                x509Key.algid = algorithmId;
                x509Key.key = byArray;
                x509Key.parseKeyBits();
                return x509Key;
            }
            System.err.println("Misconfiguration:  faulty key config, " + string);
            return new X509Key(algorithmId, byArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Misconfiguration:  unknown key class, " + string);
            return new X509Key(algorithmId, byArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new IOException(String.valueOf(string) + " [internal error]");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Misconfiguration:  faulty key class, " + string);
            return new X509Key(algorithmId, byArray);
        }
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void emit(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.algid.emit(derOutputStream2);
        derOutputStream2.putBitString(this.key);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public synchronized byte[] getEncoded() {
        block2: {
            if (this.encodedKey != null) break block2;
            try {
                this.encode();
            }
            catch (InvalidKeyException invalidKeyException) {}
        }
        return this.encodedKey;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
        }
        return this.encodedKey;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            this.algid = AlgorithmId.parse(derValue.data.getDerValue());
            this.key = derValue.data.getBitString();
            this.parseKeyBits();
            if (derValue.data.available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = key.getEncoded();
            return MessageDigest.isEqual(byArray, byArray2);
        }
        return false;
    }
}

