max_line_size	equ	16*360		; maxi. 16 inches
;
; Low-level device driver for Canon BJ-300/330 bubble jet printers in
; command mode 1 (X24E/XL24E emulation mode).
;
; The program should be assembled, linked and transformed to a .DRV file
; by "MAKEDRV.BAT". It is used by "DVI24P.EXE".
;
; The driver is essentially the following C function :
;             void far driver(int func_no,int arg1,...)
; which performs a certain number of functions. (see below for
; details concerning those functions)
;
cseg		segment	para public 'CODE'
		assume	cs:cseg,ds:nothing,es:nothing,ss:nothing
		org	0
driver		proc	far		;always a far procedure
		jmp	start
;
;------------------- Parameters -----------------------------------------
		db	'$DVI24P$'		;not to be changed
	        dw	0,360			;gives dpix*65536
		dw	0,360			;gives dpiy*65536
	        dw	0,1			;reductionx*65536
		dw	0,1			;reductiony*65536
		dw	0			;width in dots of ' '
		db	'Canon BJ-10E/300 '
		db	'(mode 2)',0		;printer id.
;------------------------------------------------------------------------
;
; definition of arguments
;
func_no		equ	[bp+6]		;function number
arg1		equ	[bp+8]		;first argument
arg2		equ	[bp+10]		;second argument
arg3		equ	[bp+12]		;third argument
;
; Jump table
func_table	label	word
		dw	func0,func1,func2,func3
		dw	func4,func5,func6,func7
;
start:					;-------The function starts here
		push	bp
		mov	bp,sp
		mov	bx,func_no
		add	bx,bx
		call	cs:[bx+offset func_table]
		pop	bp
		ret
driver		endp
;
;---------------------------- out_char -------------------------------
; send the character in AX through the following C function:
;		void far sendchar(char ch)
; The address of "sendchar" is given by function no. 0
;
out_char	proc	near
		push	ax		;arg. for "sendchar"
out_char_1:	db	9ah,?,?,?,?	;call far ????:????
		pop	ax
		ret
out_char	endp
;
;---------------------------- function 0 -------------------------------
; init. the procedure "out_char" and send the init. sequence
; for the printer. arg2:arg1 gives the address of "sendchar"
;
func0		proc	near
;
; setup out_char
		mov	ax,arg1
		mov	word ptr cs:out_char_1+1,ax
		mov	ax,arg2
		mov	word ptr cs:out_char_1+3,ax
; init. local vars.
		xor	ax,ax
		mov	cs:line_size0,ax
		mov	cs:line_size1,ax
		mov	cs:line_index,ax
		mov	cs:vspace_save,ax
;
		mov	ax,13
		jmp	out_char
		ret
func0		endp
;
;---------------------------- function 1 -------------------------------
; restore the printer
;
func1		proc	near
		ret
func1		endp
;
;---------------------------- function 2 -------------------------------
; send a form feed
;
func2		proc	near
		cmp	cs:line_index,0
		jz	func2_1
		call	send_half_line
		mov	ax,13
		call	out_char
func2_1:
		mov	cs:vspace_save,ax
		mov	cs:line_size0,ax
		mov	cs:line_size1,ax
		mov	cs:line_index,ax
		mov	ax,12
		jmp	out_char
func2		endp
;
;---------------------------- function 3 -------------------------------
; advance vertically arg1 lines (0<arg1<256, arg1 mod 24=0)
;
;
func3		proc	near
		cmp	cs:line_index,0
		jz	func3_1a
		mov	ax,arg1
		cmp	ax,24
		jnz	func3_1
		add	cs:vspace_save,ax
		ret
func3_1:
		call	send_half_line
		mov	ax,13
		call	out_char
func3_1a:
		mov	ax,28
		call	out_char
		mov	ax,'C'
		call	out_char
		mov	ax,'J'
		call	out_char
		mov	ax,4
		call	out_char
		mov	ax,arg1
		cmp	ax,255-24
		jg	func3_2
		add	ax,cs:vspace_save
		mov	cs:vspace_save,0
		jmp	out_char
func3_2:
		call	out_char
		cmp	cs:vspace_save,0
		jne	func3_3
		ret
func3_3:
		mov	word ptr arg1,0
		jmp	func3_1
func3		endp
;
;---------------------------- function 4 -------------------------------
; skip horizontally arg1 blanks (one blank=1/10 inch)
;
func4		proc	near
		mov	cx,arg1
		jcxz	func4_1
		mov	ax,' '
func4_0:
		push	cx
		call	out_char
		pop	cx
		loop	func4_0
func4_1:
		ret
func4		endp
;
;---------------------------- function 5 -------------------------------
; send begin of a data line (arg1=# of columns)
;
func5		proc	near
		mov	cx,arg1
		cmp	cx,max_line_size
		jle	func5_1
		mov	cx,max_line_size
func5_1:
		cmp	cs:line_index,0
		jnz	func5_2
		mov	cs:column_count,0
		mov	cs:line_size0,cx
		ret
func5_2:
		mov	cs:line_size1,cx
		cmp	cx,cs:line_size0
		jge	func5_3
		mov	cx,cs:line_size0
func5_3:
		call	init_gr
		mov	cs:column_count,0
		ret
func5		endp
;
;---------------------------- function 6 -------------------------------
; send the end of a data line (normally CR is sent)
;
func6		proc	near
		cmp	cs:line_index,0
		jnz	func6_1
		mov	cs:line_index,1
		ret
func6_1:
		mov	ax,cs:column_count
		mov	cx,cs:line_size0
		cmp	ax,cx
		jge	func6_2
		sub	cx,ax		;cx # of columns still to send
		mov	bx,offset line_buffer
		add	bx,ax
		add	bx,ax
		add	bx,ax
		call	send_half_line_1
func6_2:
		mov	ax,13
		call	out_char
		xor	ax,ax
		mov	cs:line_size0,ax
		mov	cs:line_size1,ax
		mov	cs:line_index,ax
		ret
func6		endp
;
;---------------------------- function 7 -------------------------------
; send one column of data (in the order of Epson LQ printers)
; arg1=byte 1, arg2=byte 2, arg3=byte 3
;
func7		proc	near
		mov	bx,offset line_buffer
		mov	ax,cs:column_count
		add	bx,ax
		add	bx,ax
		add	bx,ax
;
		cmp	cs:line_index,0
		jnz	func7_1
		mov	ax,arg1
		mov	cs:[bx],al
		inc	bx
		mov	ax,arg2
		mov	cs:[bx],al
		inc	bx
		mov	ax,arg3
		mov	cs:[bx],al
		inc	cs:column_count
		ret
func7_1:
		cmp	ax,cs:line_size0
		jge	func7_2
		call	send_3_bytes
		jmp	func7_3
func7_2:
		xor	ax,ax
		call	out_char
		call	out_char
		call	out_char
func7_3:
		inc	cs:column_count
		mov	al,byte ptr arg1
		call	out_char
		mov	al,byte ptr arg2
		call	out_char
		mov	al,byte ptr arg3
		jmp	out_char
func7		endp
;
; Since the BJ-300/330 printers print at 360x360 DPI with 48 raster lines
; at each pass, we must combine two sets of 24 raster lines into a
; single one which is sent to printer in one pass, so a buffer for
; storing data for 24 raster lines is needed.
;
line_buffer	label	byte
		db	max_line_size*3 dup (?)
;
		even
vspace_save	label	word
		dw	0
line_size0	label	word		;width of first 24 lines
		dw	0
line_size1	label	word		;width of second 24 lines
		dw	0
line_index	label	word		;0  ==> within first 24 lines
		dw	0		;!0 ==> within second 24 lines
column_count	label	word		;# of columns received
		dw	0
;
; send the 24 raster lines in line buffer to the printer
send_half_line	proc	near
		mov	bx,offset line_buffer
		mov	cx,cs:line_size0
		jcxz	send_half_line_x
		push	bx
		call	init_gr
		pop	bx
;This entry point is also used by function 6
send_half_line_1:
		push	cx
		call	send_3_bytes
		xor	ax,ax
		push	bx
		call	out_char
		call	out_char
		call	out_char
		pop	bx
		pop	cx
		loop	send_half_line_1
send_half_line_x:
		mov	cs:line_size0,ax
		mov	cs:line_size1,ax
		mov	cs:line_index,ax
		ret
send_half_line	endp
;
;send control sequence initiating 360x360 DPI graphics mode (CX
; contains # of columns and remains unchanged)
init_gr		proc	near
		push	cx
; send <FS> 'C' 'B' 4 4 CL CH
		mov	ax,28
		call	out_char
		mov	ax,'C'
		call	out_char
		mov	ax,'B'
		call	out_char
		mov	ax,4
		call	out_char
		call	out_char
		pop	cx
		push	cx
		mov	al,cl
		call	out_char
		pop	cx
		push	cx
		mov	al,ch
		call	out_char
		pop	cx
		ret
init_gr		endp
;
;send 3 bytes pointed by BX to printer
send_3_bytes	proc	near
		xor	ah,ah
		mov	al,cs:[bx]
		inc	bx
		push	bx
		call	out_char
		pop	bx
		mov	al,cs:[bx]
		inc	bx
		push	bx
		call	out_char
		pop	bx
		mov	al,cs:[bx]
		inc	bx
		push	bx
		call	out_char
		pop	bx
		ret
send_3_bytes	endp
;
cseg		ends
		end	driver
