dpi		equ	300		;600, 300, 150, 75
max_line_width	equ	12*dpi		;maxi. 12 inches
;
; Low-level device driver for HP DeskJet 500.
;
; The program should be assembled, linked and transformed to a .DRV file
; by "MAKEDRV.BAT". It is used by "DVI24P.EXE".
;
; The driver is essentially the following C function :
;             void far driver(int func_no,int arg1,...)
; which performs a certain number of functions. (see below for
; details concerning those functions). Registers other than AX, BX
; CX and DX should be reserved.
;
cseg		segment	para public 'CODE'
		assume	cs:cseg,ds:nothing,es:nothing,ss:nothing
		org	0
driver		proc	far		;always a far procedure
		jmp	start
;
;------------------- Parameters -----------------------------------------
		db	'$DVI24P$'		;not to be changed
	        dw	0,300			;gives dpix*65536
		dw	0,300			;gives dpiy*65536
	        dw	0,1			;reductionx*65536
		dw	0,1			;reductiony*65536
		dw	0			;width in dots of ' '
		db	'HP DeskJet 500',0	;gives the printer name
;------------------------------------------------------------------------
raster_buffer	label	byte			;buffer for a raster line
		db	(max_line_width+7)/8 dup (?)
line_buffer	label	byte			;buffer for data received.
		db	3*max_line_width dup (?)
line_width	label	word			;width of current line in dot
		dw	0
column_count	label	word			;# of columns received.
		dw	0
lines_sent	label	word			;# of raster lines sent
		dw	0			;since last call to func 3
;------------------------------------------------------------------------
;
; definition of arguments
;
func_no		equ	[bp+6]		;function number
arg1		equ	[bp+8]		;first argument
arg2		equ	[bp+10]		;second argument
arg3		equ	[bp+12]		;third argument
;
; Jump table
func_table	label	word
		dw	func0,func1,func2,func3
		dw	func4,func5,func6,func7
;
start:					;-------The function starts here
		push	bp
		mov	bp,sp
		mov	bx,func_no
		add	bx,bx
		call	cs:[bx+offset func_table]
		pop	bp
		ret
driver		endp
;
;---------------------------- out_char -------------------------------
; send the character in AX through the following C function:
;		void far sendchar(char ch)
; The address of "sendchar" is given by function no. 0
;
out_char	proc	near
		push	ax		;arg. for "sendchar"
out_char_1:	db	9ah,?,?,?,?	;call far ????:????
		pop	ax
		ret
out_char	endp
;
;---------------------------- function 0 -------------------------------
; init. the procedure "out_char" and send the init. sequence
; for the printer. arg2:arg1 gives the address of "sendchar"
;
func0		proc	near
;
; setup out_char
		mov	ax,arg1
		mov	word ptr cs:out_char_1+1,ax
		mov	ax,arg2
		mov	word ptr cs:out_char_1+3,ax
; init. column counter
		mov	cs:lines_sent,0
;
; init. the printer
		mov	ax,27
		call	out_char
		mov	ax,'E'
		call	out_char
; end graphics string
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,'r'
		call	out_char
		mov	ax,'B'
		call	out_char
; set resolution to 300 DPI
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,'t'
		call	out_char
		mov	ax,dpi
		call	out_dec
		mov	ax,'R'
		call	out_char
; set portrait orientation
		mov	ax,27
		call	out_char
		mov	ax,'&'
		call	out_char
		mov	ax,'l'
		call	out_char
		mov	ax,'0'
		call	out_char
		mov	ax,'O'
		call	out_char
; set bi-directional mode
;;;		mov	ax,27
;;;		call	out_char
;;;		mov	ax,'&'
;;;		call	out_char
;;;		mov	ax,'k'
;;;		call	out_char
;;;		mov	ax,'1'
;;;		call	out_char
;;;		mov	ax,'W'
;;;		call	out_char
; set perforation skip mode off
		mov	ax,27
		call	out_char
		mov	ax,'&'
		call	out_char
		mov	ax,'l'
		call	out_char
		mov	ax,'0'
		call	out_char
		mov	ax,'L'
		call	out_char
; set cursor to upper-left position
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,'p'
		call	out_char
		mov	ax,'0'
		call	out_char
		mov	ax,'x'
		call	out_char
		mov	ax,'0'
		call	out_char
		mov	ax,'Y'
		call	out_char
; start raster graphics
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,'r'
		call	out_char
		mov	ax,'1'
		call	out_char
		mov	ax,'A'
		jmp	out_char
func0		endp
;
;---------------------------- function 1 -------------------------------
; restore the printer
;
func1		proc	near
; reset the printer
		mov	ax,27
		call	out_char
		mov	ax,'E'
		jmp	out_char
func1		endp
;
;---------------------------- function 2 -------------------------------
; send a form feed
;
func2		proc	near
		mov	cs:lines_sent,0
; end raster graphics
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,'r'
		call	out_char
		mov	ax,'B'
		call	out_char
; send form feed
		mov	ax,12
		jmp	out_char
func2		endp
;
;---------------------------- function 3 -------------------------------
; advance vertically arg1 lines (0<arg1<256, arg1 mod 24=0)
;
func3		proc	near
		mov	cx,arg1
		xor	bx,bx
		xchg	bx,cs:lines_sent
		sub	cx,bx
		ja	func3_1
		ret				;nothing to do
func3_1:
;advance CX lines
;version 1: use relative vertical cursor movement
;;;		push	cx
;;;		mov	ax,27
;;;		call	out_char
;;;		mov	ax,'*'
;;;		call	out_char
;;;		mov	ax,'p'
;;;		call	out_char
;;;		mov	ax,'+'
;;;		call	out_char
;;;		pop	ax
;;;		call	out_dec
;;;		mov	ax,'Y'
;;;		jmp	out_char
;version 2: send blank lines
		push	cx
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,'b'
		call	out_char
		mov	ax,'0'
		call	out_char
		mov	ax,'W'
		call	out_char
		pop	cx
		loop	func3_1
		ret
func3		endp
;
;---------------------------- function 4 -------------------------------
; skip horizontally arg1 blanks (one blank=1/10 inch)
;
func4		proc	near
		ret			;not used
func4		endp
;
;---------------------------- function 5 -------------------------------
; begin of a data line (arg1=# of columns)
;
func5		proc	near
		mov	ax,arg1
		cmp	ax,max_line_width
		jle	func5_1
		mov	ax,max_line_width
func5_1:
		mov	cs:line_width,ax
		mov	cs:column_count,0
		ret
func5		endp
;
;---------------------------- function 6 -------------------------------
; send the end of a data line (normally CR is sent)
;
func6		proc	near
;transpose the bitmap data and send them line by line
		push	di
		mov	cx,24
func6_1:				;loop on 24 raster lines
		push	cx
		mov	bx,offset line_buffer
		mov	dx,24
		sub	dx,cx
		mov	cx,dx
		shr	dx,1
		shr	dx,1
		shr	dx,1
		add	bx,dx
		and	cl,7
		mov	dl,128
		shr	dl,cl			;dl=source mask
		mov	dh,128			;dh=target mask
		mov	cx,cs:line_width
		mov	di,offset raster_buffer
		xor	al,al
		cld
func6_2:				;loop on a raster line
		test	cs:[bx],dl
		jz	func6_3
		or	al,dh
func6_3:
		add	bx,3
		shr	dh,1
		jnz	func6_4
		mov	cs:[di],al
		inc	di
		xor	al,al
		mov	dh,128
func6_4:
		loop	func6_2
		or	dh,dh
		jz	func6_5
		mov	cs:[di],al
		inc	di
func6_5:
;send current raster line in raster_buffer (di->the end)
	;skip trailing 0's
		xor	al,al
		mov	bx,offset raster_buffer
func6_6:
		dec	di
		cmp	di,bx
		jb	func6_7
		cmp	cs:[di],al
		jz	func6_6
func6_7:
		inc	di
		mov	cx,di
		sub	cx,bx		;cx=# of bytes
		push	cx
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,'b'
		call	out_char
		pop	ax
		push	ax
		call	out_dec
		mov	ax,'W'
		call	out_char
		pop	cx
		mov	bx,offset raster_buffer
		jcxz	func6_9
func6_8:
		mov	al,cs:[bx]
		inc	bx
		push	bx
		push	cx
		call	out_char
		pop	cx
		pop	bx
		loop	func6_8
func6_9:
;pass to next raster line	
		pop	cx
		dec	cx
		jz	func6_10
		jmp	func6_1
func6_10:
		pop	di
		add	cs:lines_sent,24
		ret
func6		endp
;
;---------------------------- function 7 -------------------------------
; send one column of data (in the order of Epson LQ printers)
; arg1=byte 1, arg2=byte 2, arg3=byte 3
;
func7		proc	near
		mov	ax,cs:column_count
		cmp	ax,cs:line_width
		jl	func7_1
		ret
func7_1:
		mov	bx,offset line_buffer
		add	bx,ax
		add	bx,ax
		add	bx,ax
		mov	al,byte ptr arg1
		mov	cs:[bx],al
		inc	bx
		mov	al,byte ptr arg2
		mov	cs:[bx],al
		inc	bx
		mov	al,byte ptr arg3
		mov	cs:[bx],al
		inc	cs:column_count
		ret
func7		endp
;
out_dec		proc	near
; sending a decimal number to the printer (clearing leading 0's)
; AX contains the number to be sent (maxi. 3 digits).
		xor	bx,bx
		mov	cx,100
		call	out_dec1
		mov	cx,10
		call	out_dec1
		add	ax,'0'
		jmp	out_char
;
out_dec1:		
;send (AX/CX+'0'), set AX=AX % CX,
		xor	dx,dx
		div	cx
		add	ax,'0'
		push	dx
		or	bx,ax
		jz	out_dec2
		call	out_char
out_dec2:
		pop	ax
		ret
out_dec		endp
;
cseg		ends
		end	driver
