dpi		equ	360
max_line_width	equ	16*dpi		;maxi. 16 inches
;
; Low-level device driver for Epson LQ 850/1050 (360x360 DPI)
;
; The program should be assembled, linked and transformed to a .DRV file
; by "MAKEDRV.BAT". It is used by "DVI24P.EXE".
;
; The driver is essentially the following C function :
;             void far driver(int func_no,int arg1,...)
; which performs a certain number of functions. (see below for
; details concerning those functions). Registers other than AX, BX
; CX and DX should be reserved.
;
cseg		segment	para public 'CODE'
		assume	cs:cseg,ds:nothing,es:nothing,ss:nothing
		org	0
driver		proc	far		;always a far procedure
		jmp	start
;
;------------------- Parameters -----------------------------------------
		db	'$DVI24P$'		;not to be changed
	        dw	0,360			;gives dpix*65536
		dw	0,360			;gives dpiy*65536
	        dw	0,1			;reductionx*65536
		dw	0,1			;reductiony*65536
		dw	0			;width in dots of ' '
		db	'Epson LQ (360x360 DPI)',0	;gives the printer name
;------------------------------------------------------------------------
line_buffer	label	byte			;buffer for data received.
		db	3*max_line_width dup (?)
line_width	label	word			;width of current line in dot
		dw	0
column_count	label	word			;# of columns received.
		dw	0
vspace_save	label	word			;# of vspace saved
		dw	0
line_index	label	word
		dw	0			;0 or 1
;------------------------------------------------------------------------
;
; definition of arguments
;
func_no		equ	[bp+6]		;function number
arg1		equ	[bp+8]		;first argument
arg2		equ	[bp+10]		;second argument
arg3		equ	[bp+12]		;third argument
;
; Jump table
func_table	label	word
		dw	func0,func1,func2,func3
		dw	func4,func5,func6,func7
;
start:					;-------The function starts here
		push	bp
		mov	bp,sp
		mov	bx,func_no
		add	bx,bx
		call	cs:[bx+offset func_table]
		pop	bp
		ret
driver		endp
;
;---------------------------- out_char -------------------------------
; send the character in AX through the following C function:
;		void far sendchar(char ch)
; The address of "sendchar" is given by function no. 0
;
out_char	proc	near
		push	ax		;arg. for "sendchar"
out_char_1:	db	9ah,?,?,?,?	;call far ????:????
		pop	ax
		ret
out_char	endp
;
;---------------------------- function 0 -------------------------------
; init. the procedure "out_char" and send the init. sequence
; for the printer. arg2:arg1 gives the address of "sendchar"
;
func0		proc	near
;
; setup out_char
		mov	ax,arg1
		mov	word ptr cs:out_char_1+1,ax
		mov	ax,arg2
		mov	word ptr cs:out_char_1+3,ax
;
		mov	ax,13
		jmp	out_char
func0		endp
;
;---------------------------- function 1 -------------------------------
; restore the printer
;
func1		proc	near
; reset the printer
		mov	ax,27
		call	out_char
		mov	ax,'2'		;set 1/6" line spacing
		jmp	out_char
func1		endp
;
;---------------------------- function 2 -------------------------------
; send a form feed
;
func2		proc	near
		call	send_half_line
		mov	cs:vspace_save,0
;eject the page
		mov	ax,12
		jmp	out_char
func2		endp
;
;---------------------------- function 3 -------------------------------
; advance vertically arg1 lines (0<arg1<256, arg1 mod 24=0)
;
func3		proc	near
		mov	ax,arg1
		add	cs:vspace_save,ax
		cmp	cs:line_index,0
		jz	func3_0
		cmp	ax,24
		jnz	func3_0
		ret
func3_0:
		call	send_half_line
func3_1:
		mov	cx,cs:vspace_save
		cmp	cx,0
		jg	func3_2
		ret
func3_2:	
		cmp	cx,255
		jle	func3_3
		mov	cx,255
func3_3:
		sub	cs:vspace_save,cx
		call	func3_a
		jmp	func3_1
func3_a:				;entry point
;advance CX lines
		push	cx
		mov	ax,27
		call	out_char
		mov	ax,'+'
		call	out_char
		pop	ax
		call	out_char
		mov	ax,10
		jmp	out_char
func3		endp
;
;---------------------------- function 4 -------------------------------
; skip horizontally arg1 blanks (one blank=1/10 inch)
;
func4		proc	near
		ret			;not used
func4		endp
;
;---------------------------- function 5 -------------------------------
; begin of a data line (arg1=# of columns)
;
func5		proc	near
		mov	ax,arg1
		cmp	ax,max_line_width
		jle	func5_1
		mov	ax,max_line_width
func5_1:
		cmp	cs:line_index,0
		jnz	func5_2
		mov	cs:line_width,0
func5_2:
		cmp	ax,cs:line_width
		jle	func5_3
;if line 1>line 0 then fill extra columns in the buffer by 0
		push	di
		mov	bx,ax
		xchg	cs:line_width,bx
		sub	ax,bx
		mov	cx,ax
		add	cx,ax
		add	cx,ax
		mov	di,offset line_buffer
		add	di,bx
		add	di,bx
		add	di,bx
		push	es
		push	cs
		pop	es
		xor	al,al
		cld
		repnz	stosb
		pop	es
		pop	di
func5_3:
		mov	cs:column_count,0
		cmp	cs:line_index,0
		jnz	func5_4
		ret
func5_4:
func5_a:			;entry point
;send init. gr. string
		mov	ax,27
		call	out_char
		mov	ax,'*'
		call	out_char
		mov	ax,40
		call	out_char
		mov	al,byte ptr cs:line_width
		call	out_char
		mov	al,byte ptr cs:line_width+1
		jmp	out_char
func5		endp
;
;---------------------------- function 6 -------------------------------
; send the end of a data line (normally CR is sent)
;
func6		proc	near
		cmp	cs:line_index,0
		jnz	func6_1
		mov	cs:line_index,1
		mov	cs:column_count,0
		ret
func6_1:
		mov	ax,cs:column_count
		cmp	ax,cs:line_width
		jge	func6_1a
		push	arg1
		push	arg2
		push	arg3
		xor	ax,ax
		mov	arg1,ax
		mov	arg2,ax
		mov	arg3,ax
		call	func7
		pop	arg3
		pop	arg2
		pop	arg1
		jmp	func6_1
func6_1a:
		mov	ax,13
		call	out_char	;endup first half line
		mov	cx,1
		call	func3_a		;advance one line
		dec	cs:vspace_save
;send the second half line
		call	func5_a		;init. gr.
		mov	cx,cs:line_width
		jcxz	func6_3
		mov	bx,offset line_buffer
		xor	ax,ax
func6_2:
		push	cx
		mov	al,cs:[bx]
		inc	bx
		push	bx
		call	out_char
		pop	bx
		mov	al,cs:[bx]
		inc	bx
		push	bx
		call	out_char
		pop	bx
		mov	al,cs:[bx]
		inc	bx
		push	bx
		call	out_char
		pop	bx
		pop	cx
		loop	func6_2
func6_3:
		mov	ax,13
		call	out_char
		mov	cs:line_width,0
		mov	cs:column_count,0
		mov	cs:line_index,0
		ret
func6		endp
;
;---------------------------- function 7 -------------------------------
; send one column of data (in the order of Epson LQ printers)
; arg1=byte 1, arg2=byte 2, arg3=byte 3
;
split_byte	macro	src,dest,send_flag
		local	split_1,split_2,split_3
		mov	dl,src
		mov	dh,128
		mov	ch,4
split_1:
		test	dh,dl
		jz	split_2
		or	al,cl
split_2:
		shr	dh,1
		test	dh,dl
		jz	split_3
		or	ah,cl
split_3:
		shr	dh,1
		shr	cl,1
		dec	ch
		jnz	split_1
	if send_flag
		mov	dest,ah
		xor	ah,ah
		push	bx
		call	out_char
		pop	bx
		xor	ax,ax
		mov	cl,128
	endif
		endm
;--------------------------------------------------------
func7		proc	near
		mov	ax,cs:column_count
		cmp	ax,cs:line_width
		jl	func7_1
		ret
func7_1:
		inc	cs:column_count
		mov	bx,offset line_buffer
		add	bx,ax
		add	bx,ax
		add	bx,ax
		cmp	cs:line_index,0
		jnz	func7_2
		mov	al,byte ptr arg1
		mov	cs:[bx],al
		inc	bx
		mov	al,byte ptr arg2
		mov	cs:[bx],al
		inc	bx
		mov	al,byte ptr arg3
		mov	cs:[bx],al
		ret
func7_2:
;processing column [bx], [bx+1], [bx+2], arg1, arg2, arg3
		xor	ax,ax
		mov	cl,128
		split_byte cs:[bx],0,0
		split_byte cs:[bx+1],cs:[bx],1
		split_byte cs:[bx+2],0,0
		split_byte arg1,cs:[bx+1],1
		split_byte arg2,0,0
		split_byte arg3,cs:[bx+2],1
		ret
func7		endp
;
send_half_line	proc	near
		cmp	cs:line_index,0
		jnz	send_1
		ret
send_1:
	;begin of a new line
		sub	sp,4		;arg2, arg3 not used
		push	cs:line_width	;arg1
		mov	ax,5
		push	ax		;func_no
		call	near_driver
		add	sp,8
	;send line_width 0's
		mov	cx,cs:line_width
		jcxz	send_3
send_2:
		push	cx
		xor	ax,ax
		push	ax		;arg1
		push	ax		;arg2
		push	ax		;arg3
		mov	ax,7
		push	ax		;func_no
		call	near_driver
		add	sp,8
		pop	cx
		loop	send_2
send_3:
	;send end of data line
		sub	sp,6		;arg1, arg2, arg3 not used
		mov	ax,6
		push	ax		;func_no
		call	near_driver
		add	sp,8
		ret
near_driver:
		push	ax
		push	bp
		mov	bp,sp
		mov	bx,func_no
		add	bx,bx
		call	cs:[bx+offset func_table]
		pop	bp
		pop	ax
		ret
send_half_line	endp
;
cseg		ends
		end	driver
