;
; Low-level device driver for Star AR2463 printer.
;
; The program should be assembled, linked and transformed to a .DRV file
; by "MAKEDRV.BAT". It is used by "DVI24P.EXE".
;
; The driver is essentially the following C function :
;             void far driver(int func_no,int arg1,...)
; which performs a certain number of functions. (see below for
; details concerning those functions)
;
cseg		segment	para public 'CODE'
		assume	cs:cseg,ds:nothing,es:nothing,ss:nothing
		org	0
driver		proc	far		;always a far procedure
		jmp	start
;
;------------------- Parameters -----------------------------------------
		db	'$DVI24P$'		;not to be changed
	        dw	0,180			;gives dpix*65536
		dw	0,180			;gives dpiy*65536
	        dw	0,1			;reductionx*65536
		dw	0,1			;reductiony*65536
		dw	32767			;width in dots of ' '
		db	'Star AR-2463',0	;gives the printer name
;------------------------------------------------------------------------
;
; definition of arguments
;
func_no		equ	[bp+6]		;function number
arg1		equ	[bp+8]		;first argument
arg2		equ	[bp+10]		;second argument
arg3		equ	[bp+12]		;third argument
;
; Jump table
func_table	label	word
		dw	func0,func1,func2,func3
		dw	func4,func5,func6,func7
;
start:					;-------The function starts here
		push	bp
		mov	bp,sp
		mov	bx,func_no
		add	bx,bx
		call	cs:[bx+offset func_table]
		pop	bp
		ret
driver		endp
;
;---------------------------- out_char -------------------------------
; send the character in AX through the following C function:
;		void far sendchar(char ch)
; The address of "sendchar" is given by function no. 0
;
out_char	proc	near
		push	ax		;arg. for "sendchar"
out_char_1:	db	9ah,?,?,?,?	;call far ????:????
		pop	ax
		ret
out_char	endp
;
;---------------------------- function 0 -------------------------------
; init. the procedure "out_char" and send the init. sequence
; for the printer. arg2:arg1 gives the address of "sendchar"
;
func0		proc	near
;
; setup out_char
		mov	ax,arg1
		mov	word ptr cs:out_char_1+1,ax
		mov	ax,arg2
		mov	word ptr cs:out_char_1+3,ax
;
; init. string = Esc 'c1' 26 'F'
		mov	ax,1bh		;Esc+'c1'
		call	out_char
		mov	ax,'c'
		call	out_char
		mov	ax,'1'
		call	out_char
		mov	ax,26
		call	out_char
		mov	ax,'F'		;set 1/120 inch line spacing
		jmp	out_char
func0		endp
;
;---------------------------- function 1 -------------------------------
; restore the printer
;
func1		proc	near
		ret
func1		endp
;
;---------------------------- function 2 -------------------------------
; send a form feed
;
func2		proc	near
		mov	ax,12
		jmp	out_char
func2		endp
;
;---------------------------- function 3 -------------------------------
; advance vertically arg1 lines (0<arg1<256, arg1 mod 24=0)
;
func3		proc	near
		mov	ax,arg1
		or	ax,ax
		jnz	func3_1
		ret
func3_1:
;AX=(AX*2+1)/3
		xor	dx,dx
		mov	cx,3
		add	ax,ax
		inc	ax
		div	cx
		mov	cx,99
		xor	dx,dx
		div	cx
		push	dx
		mov	cx,ax
		or	cx,cx
		jz	vspace1
		mov	ax,1bh
		call	out_char
		mov	ax,'T'
		call	out_char
		mov	ax,'9'
		call	out_char
		mov	ax,'9'
		call	out_char
vspace0:
		push	cx
		mov	ax,13
		call	out_char
		mov	ax,10
		call	out_char
		pop	cx
		loop	vspace0
vspace1:
		pop	dx
		or	dx,dx
		jz	vspace2
		push	dx
		mov	ax,1bh			;send Esc+'W'+decimal2(AL)
		call	out_char
		mov	ax,'T'
		call	out_char
		pop	ax
		xor	ah,ah
		mov	cl,10
		div	cl
		mov	dx,3030h
		add	dx,ax
		xor	ah,ah
		mov	al,dl
		push	dx
		call	out_char
		pop	dx
		mov	al,dh
		call	out_char
vspace2:
		mov	ax,13
		call	out_char
		mov	ax,10
		jmp	out_char
func3		endp
;
;---------------------------- function 4 -------------------------------
; skip horizontally arg1 blanks (one blank=1/10 inch)
;
func4		proc	near
		mov	cx,arg1
		or	cx,cx
		jz	func4_1
		mov	ax,' '
func4_0:
		push	cx
		call	out_char
		pop	cx
		loop	func4_0
func4_1:
		ret
func4		endp
;
;---------------------------- function 5 -------------------------------
; send begin of a data line (arg1=# of columns)
;
func5		proc	near
		mov	ax,001bh
		call	out_char
		mov	ax,'J'			;Esc+'J'
		call	out_char
		mov	ax,arg1
		mov	cx,4
		jmp	outdec
func5		endp
;
;---------------------------- function 6 -------------------------------
; send the end of a data line (normally CR is sent)
;
func6		proc	near
		mov	ax,13
		jmp	out_char
func6		endp
;
;---------------------------- function 7 -------------------------------
; send one column of data (in the order of Epson LQ printers)
; arg1=byte 1, arg2=byte 2, arg3=byte 3
;
func7		proc	near
		mov	al,byte ptr arg1
		call	outdata
		mov	al,byte ptr arg2
		call	outdata
		mov	al,byte ptr arg3
		jmp	outdata
func7		endp
;
outdata		proc	near
; send the byte in al in reverse order
;
;reverse AL
		mov	ah,al
		xor	al,al
		rcr	ah,1
		rcl	al,1
		rcr	ah,1
		rcl	al,1
		rcr	ah,1
		rcl	al,1
		rcr	ah,1
		rcl	al,1
		rcr	ah,1
		rcl	al,1
		rcr	ah,1
		rcl	al,1
		rcr	ah,1
		rcl	al,1
		rcr	ah,1
		rcl	al,1
		xor	ah,ah
		jmp	out_char
outdata		endp
;
outdec		proc	near
; sending a decimal number to the printer
; AX contains the number to be sent, CL contains the number of digits
; (maxi. 5)
		cmp	cl,5
		jae	d10000
		cmp	cl,4
		jz	d1000
		cmp	cl,3
		jz	d100
		cmp	cl,2
		jz	d10
		jmp	d1
d10000:
		mov	cx,10000
		call	outdec1
d1000:
		mov	cx,1000
		call	outdec1
d100:
		mov	cx,100
		call	outdec1
d10:
		mov	cx,10
		call	outdec1
d1:
		add	ax,'0'
		jmp	out_char
;
outdec1:		
;send (AX/CX+'0'), set AX=AX % CX,
		xor	dx,dx
		div	cx
		add	ax,'0'
		push	dx
		call	out_char
		pop	ax
		ret
outdec		endp
;
cseg		ends
		end	driver
