;
; Low-level device driver for Toshiba P1350/1351.
;
; The program should be assembled, linked and transformed to a .DRV file
; by "MAKEDRV.BAT". It is used by "DVI24P.EXE".
;
; The driver is essentially the following C function :
;             void far driver(int func_no,int arg1,...)
; which performs a certain number of functions. (see below for
; details concerning those functions)
;
cseg		segment	para public 'CODE'
		assume	cs:cseg,ds:nothing,es:nothing,ss:nothing
		org	0
driver		proc	far		;always a far procedure
		jmp	start
;
;------------------- Parameters -----------------------------------------
		db	'$DVI24P$'		;not to be changed
	        dw	0,180			;gives dpix*65536
		dw	0,180			;gives dpiy*65536
	        dw	0,1			;reductionx*65536
		dw	0,1			;reductiony*65536
		dw	18			;width in dots of ' '
		db	'Toshiba P1350/1351',0	;gives the printer name
;------------------------------------------------------------------------
;
; definition of arguments
;
func_no		equ	[bp+6]		;function number
arg1		equ	[bp+8]		;first argument
arg2		equ	[bp+10]		;second argument
arg3		equ	[bp+12]		;third argument
;
; Jump table
func_table	label	word
		dw	func0,func1,func2,func3
		dw	func4,func5,func6,func7
;
start:					;-------The function starts here
		push	bp
		mov	bp,sp
		mov	bx,func_no
		add	bx,bx
		call	cs:[bx+offset func_table]
		pop	bp
		ret
driver		endp
;
;---------------------------- out_char -------------------------------
; send the character in AX through the following C function:
;		void far sendchar(char ch)
; The address of "sendchar" is given by function no. 0
;
out_char	proc	near
		push	ax		;arg. for "sendchar"
out_char_1:	db	9ah,?,?,?,?	;call far ????:????
		pop	ax
		ret
out_char	endp
;
;---------------------------- function 0 -------------------------------
; init. the procedure "out_char" and send the init. sequence
; for the printer. arg2:arg1 gives the address of "sendchar"
;
func0		proc	near
;
; setup out_char
		mov	ax,arg1
		mov	word ptr cs:out_char_1+1,ax
		mov	ax,arg2
		mov	word ptr cs:out_char_1+3,ax
;
; init. string = Esc Sub 'I'
		mov	ax,27
		call	out_char
		mov	ax,26
		call	out_char
		mov	ax,'I'
		jmp	out_char		;printer initialization (Esc+SUB+'I')
func0		endp
;
;---------------------------- function 1 -------------------------------
; restore the printer
;
func1		proc	near
		mov	ax,27
		call	out_char
		mov	ax,26
		call	out_char
		mov	ax,'I'
		jmp	out_char		;printer initialization (Esc+SUB+'I')
func1		endp
;
;---------------------------- function 2 -------------------------------
; send a form feed
;
func2		proc	near
		mov	ax,12
		jmp	out_char
func2		endp
;
;---------------------------- function 3 -------------------------------
; advance vertically arg1 lines (0<arg1<256, arg1 mod 24=0)
;
func3		proc	near
		mov	ax,arg1
		or	ax,ax
		jnz	linesp0
		ret
linesp0:
;Calculate AX=(AX*7)/24
		mov	cx,ax
		add	ax,ax		;*2
		add	ax,ax		;*4
		add	ax,ax		;*8
		sub	ax,cx
		mov	cl,24
		div	cl
		xor	ah,ah
;
		push	ax
		mov	ax,1bh			;send Esc+'L'+decimal(AL)
		call	out_char
		mov	ax,'L'
		call	out_char
		mov	cx,2
		pop	ax
		call	outdec
		mov	ax,13
		call	out_char
		mov	ax,10
		jmp	out_char
func3		endp
;
;---------------------------- function 4 -------------------------------
; skip horizontally arg1 blanks (one blank=1/10 inch)
;
func4		proc	near
		mov	cx,arg1
		or	cx,cx
		jnz	func4_1
		ret
func4_1:
		mov	ax,' '
func4_2:
		push	cx
		call	out_char
		pop	cx
		loop	func4_2
		ret
func4		endp
;
;---------------------------- function 5 -------------------------------
; send begin of a data line (arg1=# of columns)
;
func5		proc	near
		mov	ax,27
		call	out_char
		mov	ax,';'
		call	out_char
		mov	ax,arg1
		mov	cx,4
		jmp	outdec
func5		endp
;
;---------------------------- function 6 -------------------------------
; send the end of a data line (normally CR is sent)
;
func6		proc	near
		mov	ax,13
		jmp	out_char
func6		endp
;
;---------------------------- function 7 -------------------------------
; send one column of data (in the order of Epson LQ printers)
; arg1=byte 1, arg2=byte 2, arg3=byte 3
;
func7		proc	near
;;           a:=                       (b1 shr 2); write(LST,char(a));
;;           a:=((b1 and  3) shl 4) or (b2 shr 4); write(LST,char(a));
;;           a:=((b2 and 15) shl 2) or (b3 shr 6); write(LST,char(a));
;;           a:=((b3 and 63) shl 0);               write(LST,char(a));
		xor	ah,ah
		mov	al,byte ptr arg1
		mov	ch,al
		shr	al,1
		shr	al,1
		push	cx
		call	out_char
		pop	cx
		and	ch,3
		mov	cl,4
		shl	ch,cl
		mov	al,arg2
		shr	al,cl
		or	al,ch
		call	out_char
		mov	al,arg2
		and	al,15
		shl	al,1
		shl	al,1
		mov	ch,arg3
		mov	cl,6
		shr	ch,cl
		or	al,ch
		call	out_char
		mov	al,arg3
		and	al,63
		jmp	out_char
func7		endp
;
outdec		proc	near
; sending a decimal number to the printer
; AX contains the number to be sent, CL contains the number of digits
; (maxi. 5)
		cmp	cl,5
		jae	d10000
		cmp	cl,4
		jz	d1000
		cmp	cl,3
		jz	d100
		cmp	cl,2
		jz	d10
		jmp	d1
d10000:
		mov	cx,10000
		call	outdec1
d1000:
		mov	cx,1000
		call	outdec1
d100:
		mov	cx,100
		call	outdec1
d10:
		mov	cx,10
		call	outdec1
d1:
		add	ax,'0'
		jmp	out_char
;
outdec1:		
;send (AX/CX+'0'), set AX=AX % CX,
		xor	dx,dx
		div	cx
		add	ax,'0'
		push	dx
		call	out_char
		pop	ax
		ret
outdec		endp
;
cseg		ends
		end	driver
