;
; Low-level device driver for Toshiba 3070.
;
; The program should be assembled, linked and transformed to a .DRV file
; by "MAKEDRV.BAT". It is used by "DVI24P.EXE".
;
; The driver is essentially the following C function :
;             void far driver(int func_no,int arg1,...)
; which performs a certain number of functions. (see below for
; details concerning those functions)
;
cseg		segment	para public 'CODE'
		assume	cs:cseg,ds:nothing,es:nothing,ss:nothing
		org	0
driver		proc	far		;always a far procedure
		jmp	start
;
;------------------- Parameters -----------------------------------------
		db	'$DVI24P$'		;not to be changed
	        dw	0,180			;gives dpix*65536
		dw	0,180			;gives dpiy*65536
	        dw	0,1			;reductionx*65536
		dw	0,1			;reductiony*65536
		dw	32767			;width of a ' '
		db	'Toshiba 3070',0	;gives the printer name
;------------------------------------------------------------------------
;
; definition of arguments
;
func_no		equ	[bp+6]		;function number
arg1		equ	[bp+8]		;first argument
arg2		equ	[bp+10]		;second argument
arg3		equ	[bp+12]		;third argument
;
; Jump table
func_table	label	word
		dw	func0,func1,func2,func3
		dw	func4,func5,func6,func7
;
start:					;-------The function starts here
		push	bp
		mov	bp,sp
		mov	bx,func_no
		add	bx,bx
		call	cs:[bx+offset func_table]
		pop	bp
		ret
driver		endp
;
;---------------------------- out_char -------------------------------
; send the character in AX through the following C function:
;		void far sendchar(char ch)
; The address of "sendchar" is given by function no. 0
;
out_char	proc	near
		push	ax		;arg. for "sendchar"
out_char_1:	db	9ah,?,?,?,?	;call far ????:????
		pop	ax
		ret
out_char	endp
;
;---------------------------- function 0 -------------------------------
; init. the procedure "out_char" and send the init. sequence
; for the printer. arg2:arg1 gives the address of "sendchar"
;
func0		proc	near
;
; setup out_char
		mov	ax,arg1
		mov	word ptr cs:out_char_1+1,ax
		mov	ax,arg2
		mov	word ptr cs:out_char_1+3,ax
;
; init. string = Can Esc '>'
		mov	ax,18h		;CAN
		call	out_char
		mov	ax,27
		call	out_char
		mov	ax,'>'
		jmp	out_char		;unidirectional printing
func0		endp
;
;---------------------------- function 1 -------------------------------
; restore the printer
;
func1		proc	near
		ret
func1		endp
;
;---------------------------- function 2 -------------------------------
; send a form feed
;
func2		proc	near
		mov	ax,12
		jmp	out_char
func2		endp
;
;---------------------------- function 3 -------------------------------
; advance vertically arg1 lines (0<arg1<256, arg1 mod 24=0)
;
func3		proc	near
		mov	ax,27
		call	out_char
		mov	ax,'W'
		call	out_char
		mov	ax,arg1
;Calculate AX=(AX*2+1)/3
		add	ax,ax
;		inc	ax
		mov	cl,3
		div	cl
		xor	ah,ah			;ignore the residue
		mov	cx,4
		jmp	outdec
func3		endp
;
;---------------------------- function 4 -------------------------------
; skip horizontally arg1 blanks (one blank=1/10 inch)
;
func4		proc	near
		mov	cx,arg1
		or	cx,cx
		jz	func4_1
		mov	ax,' '
func4_0:
		push	cx
		call	out_char
		pop	cx
		loop	func4_0
func4_1:
		ret
func4		endp
;
;---------------------------- function 5 -------------------------------
; send begin of a data line (arg1=# of columns)
;
func5		proc	near
		mov	ax,001bh
		call	out_char
		mov	ax,'I'		;Esc+'I'
		call	out_char
		mov	cx,arg1
		mov	al,ch		;hi(nbr_col)
		push	cx
		call	out_char
		pop	cx
		mov	al,cl		;lo(nbr_col)
		jmp	out_char			
func5		endp
;
;---------------------------- function 6 -------------------------------
; send the end of a data line (normally CR is sent)
;
func6		proc	near
		mov	ax,13
		jmp	out_char
func6		endp
;
;---------------------------- function 7 -------------------------------
; send one column of data (in the order of Epson LQ printers)
; arg1=byte 1, arg2=byte 2, arg3=byte 3
;
func7		proc	near
		xor	ah,ah
		mov	al,byte ptr arg1
		call	out_char
		mov	al,byte ptr arg2
		call	out_char
		mov	al,byte ptr arg3
		jmp	out_char
func7		endp
;
outdec		proc	near
; sending a decimal number to the printer
; AX contains the number to be sent, CL contains the number of digits
; (maxi. 5)
		cmp	cl,5
		jae	d10000
		cmp	cl,4
		jz	d1000
		cmp	cl,3
		jz	d100
		cmp	cl,2
		jz	d10
		jmp	d1
d10000:
		mov	cx,10000
		call	outdec1
d1000:
		mov	cx,1000
		call	outdec1
d100:
		mov	cx,100
		call	outdec1
d10:
		mov	cx,10
		call	outdec1
d1:
		add	ax,'0'
		jmp	out_char
;
outdec1:		
;send (AX/CX+'0'), set AX=AX % CX,
		xor	dx,dx
		div	cx
		add	ax,'0'
		push	dx
		call	out_char
		pop	ax
		ret
outdec		endp
;
cseg		ends
		end	driver
