/*
******************************************************************************

   Galloc debugging macros

   Copyright (C) 2001 Christoph Egger	[Christoph_Egger@t-online.de]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GALLOC_INTERNAL_DEBUG_H
#define _GALLOC_INTERNAL_DEBUG_H


#include <ggi/internal/galloc.h>


#include <stdio.h>
#include <stdarg.h>
#include <ggi/types.h>
#include <ggi/gg.h>



__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_LIBGALLOC
extern uint32     _gallocDebugState;
extern int        _gallocDebugSync;
#else
IMPORTVAR uint32  _gallocDebugState;
IMPORTVAR int     _gallocDebugSync;
#endif
__END_DECLS


/* Debugging types
 * bit 0 is reserved! */

#define GALLOCDEBUG_CORE		(1<<1)	/*   2 */
#define GALLOCDEBUG_TARGET		(1<<2)	/*   4 */
#define GALLOCDEBUG_SHARE		(1<<3)	/*   8 */
#define GALLOCDEBUG_MODE		(1<<4)	/*  16 */
#define GALLOCDEBUG_MISC		(1<<5)	/*  32 */
#define GALLOCDEBUG_LIBS		(1<<6)	/*  64 */
#define GALLOCDEBUG_EVENTS		(1<<7)	/* 128 */

#define GALLOCDEBUG_ALL	0xffffffff


#define DEBUG_INFO	__FILE__,__PRETTY_FUNCTION__,__LINE__

#ifdef DEBUG
#define LIB_ASSERT(x)	\
	if (!(x))	\
		fprintf(stderr,"LIBGALLOC:%s:%s:%d: assertion \"%s\" failed.\n", DEBUG_INFO, #x);


#else
#define LIB_ASSERT(x)	do{}while(0)
#endif


#ifdef __GNUC__

#ifdef DEBUG
#define GALLOCDPRINT(args...)	   if (_gallocDebugState) { ggDPrintf(_gallocDebugSync, "LibGALLOC",args); }
#define GALLOCDPRINT_CORE(args...)   if (_gallocDebugState & GALLOCDEBUG_CORE) { ggDPrintf(_gallocDebugSync,"LibGALLOC",args); }
#define GALLOCDPRINT_TARGET(args...)   if (_gallocDebugState & GALLOCDEBUG_TARGET) { ggDPrintf(_gallocDebugSync,"LibGALLOC",args); }
#define GALLOCDPRINT_SHARE(args...)  if (_gallocDebugState & GALLOCDEBUG_SHARE) { ggDPrintf(_gallocDebugSync,"LibGALLOC",args); }
#define GALLOCDPRINT_MODE(args...)   if (_gallocDebugState & GALLOCDEBUG_MODE) { ggDPrintf(_gallocDebugSync,"LibGALLOC",args); }
#define GALLOCDPRINT_MISC(args...)   if (_gallocDebugState & GALLOCDEBUG_MISC) { ggDPrintf(_gallocDebugSync,"LibGALLOC",args); }
#define GALLOCDPRINT_LIBS(args...)   if (_gallocDebugState & GALLOCDEBUG_LIBS) { ggDPrintf(_gallocDebugSync,"LibGALLOC",args); }
#define GALLOCDPRINT_EVENTS(args...) if (_gallocDebugState & GALLOCDEBUG_EVENTS) { ggDPrintf(_gallocDebugSync,"LibGALLOC",args); }
#else /* DEBUG */
#define GALLOCDPRINT(args...)		do{}while(0)
#define GALLOCDPRINT_CORE(args...)	do{}while(0)
#define GALLOCDPRINT_TARGET(args...)	do{}while(0)
#define GALLOCDPRINT_SHARE(args...)	do{}while(0)
#define GALLOCDPRINT_MODE(args...)	do{}while(0)
#define GALLOCDPRINT_MISC(args...)	do{}while(0)
#define GALLOCDPRINT_LIBS(args...)	do{}while(0)
#define GALLOCDPRINT_EVENTS(args...)	do{}while(0)
#endif /* DEBUG */

#else /* __GNUC__ */

__BEGIN_DECLS

static inline void GALLOCDPRINT(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

static inline void GALLOCDPRINT_CORE(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState & GALLOCDEBUG_CORE) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

static inline void GALLOCDPRINT_TARGET(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState & GALLOCDEBUG_TARGET) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

static inline void GALLOCDPRINT_SHARE(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState & GALLOCDEBUG_SHARE) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

static inline void GALLOCDPRINT_MODE(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState & GALLOCDEBUG_DRAW) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

static inline void GALLOCDPRINT_MISC(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState & GALLOCDEBUG_MISC) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

static inline void GALLOCDPRINT_LIBS(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState & GALLOCDEBUG_LIBS) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

static inline void GALLOCDPRINT_EVENTS(const char *form,...)
{
#ifdef DEBUG
	if (_gallocDebugState & GALLOCDEBUG_EVENTS) {
		va_list args;

		fprintf(stderr, "LibGALLOC");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gallocDebugSync) fflush(stderr);
	}
#endif
}

__END_DECLS

#endif /* __GNUC__ */

#ifdef DEBUG
#define GALLOC_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LibGALLOC:%s:%s:%i: INTERNAL ERROR: %s\n",DEBUG_INFO,str); \
	exit(1); \
} }
#define GALLOC_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LibGALLOC:%s:%s:%i: APPLICATION ERROR: %s\n",DEBUG_INFO,str); \
	exit(1); \
} }
#else /* DEBUG */
#define GALLOC_ASSERT(x,str)	do{}while(0)
#define GALLOC_APPASSERT(x,str)	do{}while(0)
#endif /* DEBUG */

#ifdef DEBUG
# define GALLOCD0(x)	x
#else
# define GALLOCD0(x)	/* empty */
#endif

#ifdef GALLOCDLEV
# if GALLOCDLEV == 1
#  define GALLOCD1(x)	x
#  define GALLOCD2(x)	/* empty */
#  define GALLOCD3(x)	/* empty */
# elif GALLOCDLEV == 2
#  define GALLOCD1(x)	x
#  define GALLOCD2(x)	x
#  define GALLOCD3(x)	/* empty */
# elif GALLOCDLEV > 2
#  define GALLOCD1(x)	x
#  define GALLOCD2(x)	x
#  define GALLOCD3(x)	x
# endif
#else
# define GALLOCD1(x)	/* empty */
# define GALLOCD2(x)	/* empty */
# define GALLOCD3(x)	/* empty */
#endif

#endif /* _GALLOC_INTERNAL_DEBUG_H */
