/*
******************************************************************************

   Galloc implementation for X target - initialization.

   Display-X: initialization

   Copyright (C) 2001	Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "xgalloc.h"


static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32 *dlret)
{
	GALLOCDPRINT_LIBS("GALLOC X Open ----------------\n");
	GALLOCDPRINT_LIBS("GGIopen(%p, %p, %s, %p, %p) called for X_galloc sublib\n",
		vis, dlh, args ? args : "(NULL)", argptr, dlret);


	XGALLOC_PRIV(vis) = NULL;

#if 0
	XGALLOC_PRIV(vis) = malloc(sizeof(struct xgalloc_priv));
	if (XGALLOC_PRIV(vis) == NULL) return GGI_ENOMEM;
#endif

	LIBGGI_GALLOCEXT(vis)->check = GALLOC_X_check;
	LIBGGI_GALLOCEXT(vis)->set = GALLOC_X_set;
	LIBGGI_GALLOCEXT(vis)->release = GALLOC_X_release;
	LIBGGI_GALLOCEXT(vis)->_mode = GALLOC_X__mode;
	LIBGGI_GALLOCEXT(vis)->checkifshareable = GALLOC_X_checkifshareable;


	*dlret = (GGI_DL_EXTENSION | GGI_DL_OPDISPLAY);
	return 0;
}	/* GGIopen */


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	GALLOCDPRINT_LIBS("GGIclose(%p, %p) called for X_galloc sublib\n",
	       vis, dlh);

#if 0
	free(XGALLOC_PRIV(vis));
	XGALLOC_PRIV(vis) = NULL;
#endif

	return 0;
}	/* GGIclose */


int GALLOCdl_X_galloc(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GALLOCdl_X_galloc */

/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
