/* $Id: ptlock.c,v 1.1.1.1 2001/05/12 23:00:04 cegger Exp $
******************************************************************************

   LibGG - Mutex implementation using pthreads

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include <errno.h>
#include <ggi/gg.h>
#include "plat.h"

#ifdef HAVE_PTHREAD_H
#define __C_ASM_H /* Fix for retarded Digital Unix header */
#include <pthread.h>
#endif

void  *ggLockCreate(void)
{
	pthread_mutex_t *ret;
	
	if ((ret = malloc(sizeof(pthread_mutex_t))) != NULL) {
		if (pthread_mutex_init(ret, NULL) != 0) {
			free((void*)ret);
			return (void *) NULL;
		}
	}
	return (void *) ret;
}

int ggLockDestroy(void *lock) {
	if (pthread_mutex_destroy((pthread_mutex_t*)lock) != 0) {
		return GGI_EBUSY;
	}
	free(lock);
	return 0;
}
	
int ggLock(void *lock) {
	if (pthread_mutex_lock((pthread_mutex_t*)lock) != 0) {
		return GGI_EUNKNOWN;
	}
	return 0;
}

int ggUnlock(void *lock) {
	if (pthread_mutex_unlock((pthread_mutex_t*)lock) != 0) {
		return GGI_EUNKNOWN;
	}
	return 0;
}


int ggTryLock(void *lock) {
	switch (pthread_mutex_trylock((pthread_mutex_t*)lock)) {
	case 0:	return 0;

	case EBUSY: return GGI_EBUSY;
	}
	return GGI_EUNKNOWN;
}

int _ggInitLocks(void) {
	return 0;
}

void _ggExitLocks(void) {
	return;
}
