/* $Id: misc.c,v 1.6 2002/10/16 21:26:40 cegger Exp $
******************************************************************************

   LibGG - Misc utility functions

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <ggi/gg.h>
#include "plat.h"

#ifndef PATH_MAX
# ifdef _POSIX_PATH_MAX
#  define PATH_MAX _POSIX_PATH_MAX
# else
#  define PATH_MAX 4096 /* Should be enough for most systems */
# endif
#endif

/* FIXME - make win32 and other systems do the right thing here */

#define APPENDNAME	"/.ggi"
#define APPENDLEN	5

const char *ggGetUserDir(void)
{
	static char curpath[PATH_MAX+1];
	char *ptr;
	int len;

	ptr = getenv("HOME");
	if (ptr == NULL) {
		/* hmm... $HOME is not there... */

#if defined(macintosh) || (defined(__MACH__) && defined(__APPLE__))
#define HAVE_TMP_PATH
		/* Darwin 6.x */
		const char *uid = getenv("UID");
		ptr = malloc(strlen(uid) + strlen("/tmp//Temporary Items")+1);
		sprintf(ptr, "/tmp/%s/Temporary Items", uid);

#endif	/* MAC OS / DARWIN */

#if defined(_POSIX_SOURCE) || defined(__OpenBSD__) || defined(__NetBSD__) \
		|| defined(__CYGWIN__)
#define HAVE_TMP_PATH
		/* this hopefully catches all unix environments */
		ptr = "/tmp";

#endif	/* Unix */

#if defined(__WIN32__) && !defined(__CYGWIN__)
#define HAVE_TMP_PATH
		/* Should catch all win32 platforms */
#error Set ptr to an appropriate common default path for win32 platforms.
#endif	/* __WIN32__ */

#ifndef HAVE_TMP_PATH
		/* Catch all other platforms */
#error You need to set ptr for this system
#endif
	}	/* if */

	len = strlen(ptr);
	if (len + APPENDLEN > PATH_MAX) return NULL;

	/* Must lock here */
	ggLock(_gg_global_mutex);
	strcpy(curpath, ptr);
	strcpy(curpath+len, APPENDNAME);
	ggUnlock(_gg_global_mutex);

	return curpath;
}

#ifndef GG_USLEEP_DEFINED
#error You need to implement ggUSleep() for this system
#endif

#ifndef GG_CURTIME_DEFINED
#error You need to implement ggCurTime() for this system
#endif
