/*
******************************************************************************

   Demo of the Galloc extension.

   Authors:	2001 Christoph Egger	[Christoph_Egger@t-online.de]
  
   This code is placed in the public domain and may be used freely for any
   purpose.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ggi/ggi.h>
#include <ggi/galloc.h>


static int do_demo(ggi_visual_t vis)
{
	int rc = 0;
	char *pr;
	ggiGA_resource_list r1, r2;
	struct ggiGA_resource_props p;

	ggiGA_resource_handle frame_res;
	ggiGA_resource_handle res1;
	ggiGA_resource_handle res2;
	ggiGA_resource_handle res3;
	ggiGA_resource_handle res4;
	ggiGA_resource_handle res5;

	memset(&p, 0, sizeof(p));

#warning This code uses some functions not in the external API
#warning Expect some implicit declaration warnings.

	/* Do some calisthenics with the internal list operations */
	printf("ggiGAanprintf of an empty list:\n");
	r1 = NULL;
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("%s", pr);	    
	free(pr);

	/* Make a 1-element list, using the "gray area" functions. */
	r1 = ggiGACopyIntoResource(&p, NULL, 0);
	ggiGASetType(r1, GA_RT_BUFFER_SBUFFER);
	printf("ggiGAanprintf of a one element list:\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("%s", pr);	    
	free(pr);

	/* Add 5 elements using the regular API. */
	ggiGAAdd(&r1, &p, GA_RT_WINDOW_YUV, &res1);
	ggiGAAdd(&r1, &p, GA_RT_MOTOR | GA_RT_VIDEO_MOTION, &res2);
	ggiGAAdd(&r1, &p, GA_RT_SPRITE_SPRITE, &res3);
	ggiGAAdd(&r1, &p, GA_RT_SPRITE_POINTER, &res4);
	ggiGAAdd(&r1, &p, GA_RT_MOTOR | GA_RT_MISC_RAYPOS, &res5);
	printf("ggiGAanprintf of a six element list:\n");
	ggiGAanprintf(vis, r1, 8192, NULL, &pr);
	printf("%s", pr);	    
	free(pr);

	/* Delete the second element */
	ggiGARemove(&r1, &res1);
	printf("Same list with second resource ggiGARemove()d:\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("%s", pr);	    
	free(pr);

	/* Delete the first element */
	ggiGARemove(&r1, &r1);
	printf("Same list with first resource ggiGARemove()d:\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("%s", pr);	    
	free(pr);

	/* Delete the last element */
	ggiGARemove(&r1, &res5);
	printf("Same list with last resource ggiGARemove()d:\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("%s", pr);	    
	free(pr);

	/* Test CopyList */
	r2 = NULL;
	ggiGACopyList(r1, &r2);
	printf("A ggiGACopyList of that last list\n");
	ggiGAanprintf(vis, r2, 8092, NULL, &pr);
	printf("%s", pr);	    
	free(pr);

	/* Test AppendList */
	ggiGAAppendList(r2, &r1);
	printf("ggiGAAppendList of those last two\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("%s", pr);
	free(pr);

	/* Test EmptyList */
	ggiGAEmptyList(&r1);
	printf("Destroying the list; This should print an empty list:\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("%s", pr);
	free(pr);

	r2 = NULL;
	res1 = res2 = res3 = res4 = res5 = NULL;

        /* From here down external API functions only should be used. */

	/* Check Addmode */
        printf("Adding a mode to the list with ggiGAAddSimpleMode\n");
	frame_res = NULL;
	rc = ggiGAAddSimpleMode(vis, &r1,
				GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO, 
				&frame_res);
	printf("galloctest: done - rc: %i\n", rc);

	printf("galloctest: call ggiGAanprintf\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("galloctest: done - pr: \n%s\n", pr);
	free(pr);

	r2 = NULL;

	printf("galloctest: call ggiGACheck\n");
	rc = ggiGACheck(vis, r1, &r1);
	printf("galloctest: done - rc: %i\n", rc);

	printf("galloctest: call ggiGAanprintf\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("galloctest: done - pr: \n%s\n", pr);
	free(pr);

	printf("galloctest: call ggiGASet\n");
	rc = ggiGASet(vis, r1, &r1);
	printf("galloctest: done - rc: %i\n", rc);

	printf("galloctest: call ggiGAanprintf\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("galloctest: done - pr: \n%s\n", pr);
	free(pr);

	for (;;) {

		ggi_event ev;

                struct timeval timeout={0,1000};

                ggiEventPoll(vis, emAll, &timeout);
                usleep(timeout.tv_usec);

		while (ggiEventsQueued(vis, emAll)) {
			ggiEventRead(vis, &ev, emAll);

			switch(ev.any.type) {
			case evKeyPress:
			case evKeyRepeat:

				switch(ev.key.sym) {
				case GIIK_Enter:
					break;

				case GIIUC_Escape:
					goto cleanup;

				}	/* switch */
			}	/* switch */	
		}	/* while */

		ggiFlush(vis);
	}	/* for */

cleanup:

	printf("galloctest: call ggiGAReleaseList\n");
	rc = ggiGAReleaseList(vis, &r1);
	printf("galloctest: done - rc: %i\n", rc);

#if 1
	printf("galloctest: call ggiGAanprintf\n");
	ggiGAanprintf(vis, r1, 8092, NULL, &pr);
	printf("galloctest: done - pr: \n%s\n", pr);
	free(pr);
#endif

	return rc;
}


int main(void)
{
	ggi_visual_t vis;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize Galloc extension */
	if (ggiGAInit() != 0) {
		ggiPanic("Unable to initialize LibGalloc extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Attach the Galloc extension to the visual */
	if (ggiGAAttach(vis) < 0) {
		ggiPanic("Unable to attach Galloc extension to visual\n");
	}



	/* Try the API functions */
	do_demo(vis);

	
	/* Detach extension from visual */
	ggiGADetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize Galloc extension */
	ggiGAExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
