/*
******************************************************************************

   LibGalloc: extension stubs

   Copyright (C) 2001 Christoph Egger   [Christoph_Egger@t-online.de]
   Copyright (C) 2001 Brian S. Julin    [bri@calyx.com]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/galloc.h>
#include <ggi/internal/galloc_debug.h>
#include <ggi/ga_prop.h>
#include <stdio.h>
#include <string.h>

int ggiGACheck(ggi_visual_t vis, ggiGA_resource_list request,
               ggiGA_resource_list *result)
{
        return LIBGGI_GALLOCEXT(vis)->check(vis, request, result);
}       /* ggiGACheck */


int ggiGASet(ggi_visual_t vis, ggiGA_resource_list request,
             ggiGA_resource_list *result)
{
        return LIBGGI_GALLOCEXT(vis)->set(vis, request, result);
}       /* ggiGASet */


int ggiGARelease(ggi_visual_t vis, ggiGA_resource_list *list,
                 ggiGA_resource_handle *handle)
{
        return LIBGGI_GALLOCEXT(vis)->release(vis, list, handle);
}       /* ggiGARelease */

int ggiGAanprintf(ggi_visual_t vis, ggiGA_resource_list request, 
		  size_t size, char *format, char **out)
{
	return LIBGGI_GALLOCEXT(vis)->anprintf(vis,request,size,format,out);
}	/* ggiGAanprintf */

/* Internal use only */
int ggiGA_Mode(ggi_visual_t vis, ggiGA_resource_handle *out)
{
	return LIBGGI_GALLOCEXT(vis)->_mode(vis, out);
}	/* ggiGA_Mode */


int ggiGACheckIfShareable(ggi_visual_t vis, 
		    ggiGA_resource_handle reshandle,
		    ggiGA_resource_handle tocompare)
{
	return LIBGGI_GALLOCEXT(vis)->checkifshareable(vis, reshandle, tocompare);
}	/* ggiGACheckIfShareable */
