/*
******************************************************************************

   Galloc implementation for X target - header.

   Copyright (C) 2001	Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_GALLOC_X_H
#define _GGI_GALLOC_X_H


#include <ggi/internal/galloc.h>
#include <ggi/internal/galloc_debug.h>
#include <ggi/display/x_galloc.h>



/*
 *	"exported" Function prototypes
 */
GASet			GALLOC_X_set;
GACheck			GALLOC_X_check;
GARelease		GALLOC_X_release;
GA_Mode			GALLOC_X__mode;
GACheckIfShareable	GALLOC_X_checkifshareable;


extern ggiGA_resource_list x_haslist;

ggiGA_reslist_callback x_galloc_check_mode;
ggiGA_reslist_callback x_galloc_check_cladbuf;
ggiGA_reslist_callback x_galloc_set_mode;


/* Structure holding private data.
 */
struct xgalloc_priv {
	void *dummy;
};


#define XGALLOC_PRIV(vis) ((struct xgalloc_priv *)(LIBGGI_GALLOCEXT(vis)->priv))


struct xgalloc_container_t {
	int state;

	ggi_mode *mode;
	ggiGA_resource_handle mode_handle;
};



int check_frame(ggi_visual_t vis,
                 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
                 ggiGA_resource_handle lastmode);
int set_frame(ggi_visual_t vis,
                 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
                 ggiGA_resource_handle lastmode);
int release_frame(ggi_visual_t vis,
                 ggiGA_resource_handle handle);


int check_renderer(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
		 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int set_renderer(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int release_renderer(ggi_visual_t vis,
		 ggiGA_resource_handle handle);


int check_sprite(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
		 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int set_sprite(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int release_sprite(ggi_visual_t vis,
		 ggiGA_resource_handle handle);



int check_bob(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
		 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int set_bob(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int release_bob(ggi_visual_t vis,
		 ggiGA_resource_handle handle);


int check_buffer(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
		 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int set_buffer(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int release_buffer(ggi_visual_t vis,
		 ggiGA_resource_handle handle);


int check_window(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
		 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int set_window(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int release_window(ggi_visual_t vis,
		 ggiGA_resource_handle handle);


int check_misc(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
		 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int set_misc(ggi_visual_t vis,
		 ggiGA_resource_handle handle,
                 ggiGA_resource_handle compound,
		 ggiGA_resource_handle lastmode);
int release_misc(ggi_visual_t vis,
		 ggiGA_resource_handle handle);


#endif	/* _GGI_GALLOC_X_H*/
