/* $Id: bsetest.c,v 1.1.1.1 2001/05/01 18:45:16 cegger Exp $
******************************************************************************

   Test program for the "BSE" i.e. BobSpriteEmusprite extension.

   Copyright (C) 1999 Andreas Beck - becka@ggi-project.org
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/gg.h>
#include <ggi/ggi.h>
#include <ggi/ggi_ext.h>

#include <ggi/bse.h>

void make_alphahardcircle(unsigned char *alpha, int width, int height)
{
	int x,y;

	/* Circle */
	for(x = 0; x < height; x++) {
		for (y = 0; y < width; y++) {
			*alpha++ = ((y - height/2)
				* (y - height/2) + (x - width / 2)
				* (x - width/2)) < width * height/4
				? 0x00 : 0xFF;
		}	/* for */
	}	/* for */
}	/* make_alphahardcircle */


void make_alphasoftcircle(unsigned char *alpha, int width, int height)
{
	int x,y;

	/* Circle */
	for(x = 0; x < height; x++) {
		for(y = 0; y < width; y++) {
			*alpha++ = ((y - height/2)
				* (y - height/2) + (x - width/2)
				* (x - width/2)) < width * height/4
				? 0xFF * (((y - height/2) * (y - height/2)
				+ (x - width/2) * (x - width/2)))
				/ (width * height/4) : 0xFF;
		}	/* for */
	}	/* for */
}	/* make_alphasoftcircle */



static int do_demo(ggi_visual_t vis)
{
	ggi_color col;
	ggi_mode mode;
	int temp, inc, width, height;
	ggiBse_t sprite, bob;
	unsigned char alpha[50*50], *alph;


	/* Set foreground color to white */
	col.r = 0xffff;
	col.g = 0xffff;
	col.b = 0xffff;
	ggiSetGCForeground(vis, ggiMapColor(vis, &col));

	/* Check what mode we actually got */
	ggiGetMode(vis, &mode);
	width = mode.visible.x;
	height = mode.visible.y;
	
	/* Draw a bunch of lines... */
	inc = height / 66;
	for (temp = 0; temp <= (height-inc); temp += inc) {
		ggiDrawLine(vis, 0, temp, width - 1, height - temp);
	}	/* for */

	/* ...and flush the screen */
	ggiFlush(vis);


	/* Now test the BSE stuff */
	sprite = ggiBseCreateSprite(vis, 50,50, GT_AUTO);
	bob    = ggiBseCreateBob(vis, 50,50, GT_AUTO);

	printf("objects are: sprite: %p (%s), bob: %p\n",
		sprite,
		(sprite != NULL) ? (ggiBseIsSpriteEmulated(sprite) ? "emulated" : "real") : "NULL",
		bob);

	if (!ggiBseIsSpriteEmulated(sprite)) {
		ggiBseSetImage(sprite, vis, 10,10, NULL);
		ggiBseMove(sprite, 60,60);
		ggiBseShow(sprite);

		for (temp = 1; temp < height; temp += 10) {
			ggiBseMove(sprite, temp,temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(100000);
		}	/* for */

		ggiBseHide(sprite);
	}	/* if */


	if (ggiBseIsSpriteEmulated(sprite)) {

		ggiBseSetImage(sprite, vis, 10,10, NULL);
		ggiBseMove(sprite, 60,60);
		ggiBseShow(sprite);
		ggiFlush(vis);

		for (temp = 1; temp < height; temp += 10) {
			ggiBseMove(sprite, temp,temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */

		ggiBseHide(sprite);
		make_alphahardcircle(alpha, 50,50);
		ggiBseSetImage(sprite, vis, 10,10, alpha);
		ggiBseMove(sprite,60,60);
		ggiBseShow(sprite);
		ggiFlush(vis);

		for (temp = 1; temp < height; temp += 10) {
			ggiBseMove(sprite, temp,height-1 - temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */

		ggiBseHide(sprite);
		make_alphasoftcircle(alpha, 50,50);
		ggiBseSetImage(sprite, vis, 10,10, alpha);
		ggiBseMove(sprite,60,60);
		ggiBseShow(sprite);

		for (temp = 1; temp < height; temp += 10) {
			ggiBseMove(sprite, temp,temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */

		ggiBseHide(sprite);
		alph = ggiBseMakeAlphaFromPixelkey(sprite,vis,10,30,0);
		ggiBseSetImage(sprite, vis, 10,10, alph);
		free(alph);
		ggiBseMove(sprite,60,60);
		ggiBseShow(sprite);

		for (temp = 1; temp < height; temp += 10) { 
			ggiBseMove(sprite,temp,height-1 - temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */

		ggiBseHide(sprite);
		alph = ggiBseMakeAlphaFromColorkey(sprite,vis,10,30,&col);
		ggiBseSetImage(sprite, vis, 10,10, alph);
		free(alph);
		ggiBseMove(sprite, 60,60);
		ggiBseShow(sprite);

		for (temp = 1; temp < height; temp += 10) { 
			ggiBseMove(sprite,temp,height-1 - temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */

		ggiBseHide(sprite);
	}	/* if */


	if (bob) {
		ggiBseSetImage(bob, vis, 10,10, NULL);
		ggiBseMove(bob, 60,60);
		ggiBseShow(bob);
		for (temp = 1; temp < height; temp += 60) { 
			ggiBseMove(bob, temp,temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */

		ggiBseHide(bob);
		make_alphahardcircle(alpha,50,50);
		ggiBseSetImage(bob, vis, 10,10, alpha);
		ggiBseMove(bob, 60,60);
		ggiBseShow(bob);

		for (temp = 1; temp < height; temp += 60) { 
			ggiBseMove(bob,temp,height-1 - temp);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */

		ggiBseHide(bob);
		make_alphasoftcircle(alpha, 50,50);
		ggiBseSetImage(bob, vis, 10,10, alpha);
		ggiBseMove(bob, 60,60);
		ggiBseShow(bob);

		for (temp = 1; temp < height; temp += 60) { 
			ggiBseMove(bob, temp,temp/2);
			ggiFlush(vis);
			if (ggiKbhit(vis)) goto cleanup;
			ggUSleep(10000);
		}	/* for */
		ggiBseHide(bob);
	}	/* if */

	ggiFlush(vis);
	if (ggiKbhit(vis)) goto cleanup;

  cleanup:
	ggiBseDestroy(sprite);
	ggiBseDestroy(bob);

	return 0;
}	/* do_demo */




int main(void)
{
	ggi_visual_t vis;
	
	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize BSE */
	if (ggiBseInit() != 0) {
		ggiPanic("Unable to initialize LibBSE\n");
	}	/* if */

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}	/* if */
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}	/* if */

	
	/* Attach the BSE lib to the visual */
	if (ggiBseAttach(vis) < 0) {
		ggiPanic("Unable to attach BSE extension to visual\n");
	}	/* if */


	do_demo(vis);


	/* Detach extension from visual */
	ggiBseDetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize BSE lib */
	ggiBseExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}	/* main */
