/* $Id: bse.h,v 1.1.1.1 2001/05/01 18:46:59 cegger Exp $
******************************************************************************

   LibGGI BSE internals

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 2001 Christoph Egger	[Christoph_Egger@t-online.de]

  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_BSE_INT_H
#define _GGI_BSE_INT_H

#include <ggi/internal/internal.h>

#define HAVE_STRUCT_BSE

#include <ggi/bse.h>

#include <ggi/ovl.h>
#include <ggi/blt.h>


#define DEBUG_INFO	__FILE__,__PRETTY_FUNCTION__,__LINE__


enum bsetype {
	BSE_BOB,
	BSE_SPRITE,
	BSE_EMUSPRITE
};

struct ggi_emusprite_t {
	ggiBlt_t bob;
	void *backgr;
};


struct ggiBse {
	struct ggiBse *prev,*next;
	ggi_visual_t vis;
	int x,y,w,h, cw,ch;
	enum bsetype type;
	int hidecount;
	union {
		ggiBlt_t		bob;
		ggiOvl_t		sprite;
		struct ggi_emusprite_t	emusprite;
	} subtype;
};


struct resourcelist_t {
	struct resourcelist_t *next;
	ggi_visual_t vis;
	struct ggiBse *first;
};

extern struct resourcelist_t *reslist;


#define ADD_NEW_RESOURCE(res_index, new_res)	\
	new_res->next = NULL;			\
	res_index = reslist;			\
	while (res_index && res_index->next) {	\
		res_index = res_index->next;	\
	}					\
	if (res_index) {			\
		res_index->next = new_res;	\
	} else {				\
		reslist = res_index = new_res;	\
	}

#define REMOVE_RESOURCE(res, res_index)			\
	res_index = reslist;				\
	if (res_index == res) {				\
		reslist = reslist->next;		\
	} else {					\
		while (res_index->next != res) {	\
			res_index = res_index->next;	\
		}					\
		res_index->next = res->next;		\
	}


#define DESTROY_RESOURCE(res)			\
	{					\
	struct resourcelist_t *res_index;	\
	REMOVE_RESOURCE(res, res_index);	\
	free(res);				\
	}


#define FIND_RESOURCE(visual, res_index)	\
	res_index = reslist;			\
	while (res_index) {			\
		if (res_index->vis == visual) {	\
			break;			\
		}				\
		res_index = res_index->next;	\
	}



#define ADD_NEW_BSE(bse_index, bse_first, new_bse)	\
	new_bse->next = NULL;				\
	bse_index = bse_first;				\
	while (bse_index && bse_index->next) {		\
		bse_index = bse_index->next;		\
	}						\
	new_bse->prev = bse_index;			\
	if (bse_index) {				\
		bse_index->next = new_bse;		\
	} else {					\
		bse_first = bse_index = new_bse;	\
	}


#define REMOVE_BSE(bse, bse_first)			\
	if (bse->prev) {				\
		bse->prev->next = bse->next;		\
	} else {					\
		bse_first = bse->next;			\
	}						\
	if (bse->next) {				\
		bse->next->prev = bse->prev;		\
	}


#define DESTROY_BSE(bse, bse_first)			\
	REMOVE_BSE(bse, bse_first);			\
	free(bse);					\
	bse = NULL;




#endif /* _GGI_BSE_INT_H */
