/* $Id: head.c,v 1.1.1.1 2001/04/22 19:02:57 cegger Exp $
******************************************************************************

   LibGIC - Heads

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ggi/gic.h>

gic_head *gicHeadAllocate	(gic_handle_t hand,char *name)
{
	gic_head *ret;
	
	if ((ret=malloc(sizeof(gic_head)))) {
		strncpy(ret->name,name,65);
		ret->name[65-1]=0;
		ret->contexts=NULL;
	}
	return ret;
}

void	  gicHeadFree		(gic_handle_t hand,gic_head *head)
{
	free(head);
}

int	  gicHeadAttachContext	(gic_handle_t hand,gic_head *head,gic_context *context)
{
	gic_contextlist *listitem,*cur;

	if (NULL==(cur=malloc(sizeof(gic_contextlist)))) {
		return -1;	/* NOMEM */
	}

	cur->next = NULL;
	cur->context = context;

	if (head->contexts == NULL) {
		head->contexts = cur;
		return 0;
	}

        for (listitem = head->contexts;
             listitem->next;
             listitem = listitem->next) {
        }

	listitem->next = cur;
	return 0;
}

int	  gicHeadDetachContext	(gic_handle_t hand,gic_head *head,gic_context *context)
{
	gic_contextlist *listitem,**last;

	for(listitem=head->contexts,last=&head->contexts;
		listitem!=NULL;listitem=*(last=&listitem->next))
	{
		if (listitem->context==context) {
			*last=listitem->next;
			free(listitem);
			return 0;
		}
	}
	return -1;
}

gic_context  *gicHeadLookupContext	(gic_handle_t hand,gic_head *head,const char *name)
{
	gic_contextlist *listitem;

	for(listitem=head->contexts;
		listitem!=NULL;listitem=listitem->next)
	{
		if (0==strcmp(listitem->context->name,name)) {
			return listitem->context;
		}
	}
	return NULL;
}

gic_context *gicHeadGetContext		(gic_handle_t hand,gic_head *head, int number)
{
	gic_contextlist *listitem;

	for (listitem = head->contexts;
	     listitem != NULL;
	     listitem = listitem->next) {
		if (number--==0)
			return listitem->context;
	}
	return NULL;
}

int gicHeadNumContexts			(gic_handle_t hand,gic_head *head)
{
	int count=0;
	gic_contextlist *listitem;

	for (listitem = head->contexts;
	     listitem != NULL;
	     listitem = listitem->next) {
		count++;
	}
	return count;
}

int	gicHeadWrite			(gic_handle_t hand,gic_head *head,FILE *where)
{
	gic_contextlist *listitem;

	fprintf(where,"gic:Head \"%s\"\n",head->name);
	for(listitem=head->contexts;listitem!=NULL;listitem=listitem->next)
	{
		gicContextWrite(hand,listitem->context,where);
	}
	fprintf(where,"gic:Head END\n");

	return 0;
}

gic_head	*gicHeadRead		(gic_handle_t hand,FILE *where)
{
	gic_context	*context;
	gic_head	*head;
	char buffer[1024],*hlp;

	fgets(buffer, sizeof(buffer), where);
	if ( 0==strncmp("gic:Head \"",buffer,10) && 
	     (hlp=strchr(buffer+10,'"'))) {
		*hlp='\0';	/* Terminate string */
		head=gicHeadAllocate(hand,buffer+10);
		if (head==NULL) return NULL;

		/* Attention: The last gicContextRead will fail, as it reads
		 * the gic:Head END. This is intended behaviour. It detects
		 * the end of the contexts.
		 */
		while( (context=gicContextRead(hand,where)) )
			gicHeadAttachContext(hand,head,context);

		return head;
	}
	return NULL;
}

int	gicHeadMapActions		(gic_handle_t hand,gic_head *head,gic_actionlist *actions)
{
	gic_contextlist *listitem;

	for(listitem=head->contexts;listitem!=NULL;listitem=listitem->next)
	{
		gicContextMapActions(hand,listitem->context,actions);
	}

	return 0;
}
