/*
******************************************************************************

   The Snazzy Config Manager
  
   Copyright (c) 1999  Andrew Apted  [andrew@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
  
******************************************************************************
*/

#ifndef _SNAZZYMGR_H
#define _SNAZZYMGR_H

#include <ggi/ggi.h>


#ifndef MAX
#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a, b)  ((a) < (b) ? (a) : (b))
#endif


extern unsigned char coded_smoothtex[];
extern unsigned char coded_roughtex[];
extern unsigned char coded_ggitex[];
extern unsigned char coded_bigfont[];
extern unsigned char coded_smallfont[];


/*----  UTILITY FUNCTIONS (in util.c)  ----*/


/**
 *  Decode an image, which is of the given size, storing the result in
 *  an allocated block of memory, and return it.  Returns NULL if an
 *  error occurs (such as out of memory, or bad image data).
 */
unsigned char *decode_image(unsigned char *img, int width, int height);

/**
 *  Draw a decoded image, at the coordinates (x, y) and size (w, h).
 *  The image size is given by (iw, ih), and an offset into the image is
 *  given by (ix, iy).  If the box size is greater than the image size,
 *  then the image is tiled.  The image is drawn with colors from the
 *  `colors' array.
 */
void draw_image(ggi_visual_t vis, int x, int y, int w, int h,
		unsigned char *img, int ix, int iy, int iw, int ih, 
		ggi_pixel *colors);

/**
 *  Draw a character from a decoded font, at the coordinates (x, y) with
 *  unicode value `c' (only Latin 1 supported though).  Pixels of value
 *  0 in the font image are `transparent' and not drawn, otherwise the
 *  character is drawn with the colors in the `colors' array (to be
 *  precise: pixel 1 is drawn using colors[0], etc..).
 */
void draw_char (ggi_visual_t vis, int x, int y, int c, 
		unsigned char *font, int fw, int fh, ggi_pixel *colors); 

/**
 *  Draw a string of characters contained in `s' (assumed to be Latin 1
 *  charset) at the given coordinates (x, y) and with the given font and
 *  colors.
 */
void draw_string(ggi_visual_t vis, int x, int y, unsigned char *s, 
		 unsigned char *font, int fw, int fh, int step,
		 ggi_pixel *colors); 

/**
 *  Draw a snazzy string 's', which is drawn vertically downwards and
 *  textured with the image `img'.  This is only used for the title at
 *  the side of the screen.
 */
void draw_snazzy_string(ggi_visual_t vis, int x, int y, 
			int x_scale, int y_scale,
			unsigned char *s, unsigned char *font, 
			int fw, int fh, unsigned char *img,
                        int iw, int ih, ggi_pixel *colors);


#endif /* _SNAZZYMGR_H */
