/*
******************************************************************************

   Demo of the GPF library.

   Authors:	2002 Christoph Egger	[Christoph_Egger@t-online.de]
  
   This code is placed in the public domain and may be used freely for any
   purpose.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/ggi.h>
#include <ggi/gpf.h>


#if 1
#define USE_PARAMS
#endif

static int do_scroll(ggi_visual_t vis, ggi_mode *mode,
		int *x, int *y, int *xstep, int *ystep)
{
	int xdot, ydot;

	if (x[0]+mode->visible.x >= mode->virt.x || x[0] < 0) {
		xstep[0] = -xstep[0];
	}	/* if */

	if (y[0]+mode->visible.y >= mode->virt.y || y[0] < 0) {
		ystep[0] = -ystep[0];
	}	/* if */

	xdot = x[0] * mode->dpp.x;
	ydot = y[0] * mode->dpp.y;
	x[0] += xstep[0];
	y[0] += ystep[0];
	ggiSetOrigin(vis, xdot, ydot);

	return 0;
}	/* do_scroll */





static int do_demo(ggi_visual_t vis, const char *filename)
{
	int rc;
	gpf_handle_t handle;
	struct gpf_properties_t props;
	ggi_mode mode;
	char mode_str[40];
	int x, y;
	int xstep, ystep;

	ggiGetMode(vis, &mode);

	ggiSPrintMode(mode_str, &mode);
	printf("mode: %s\n", mode_str);


	handle = gpfOpen("ppm", filename, 
			"libggi", "-vis=%p", vis);

	if (!handle) gpfPanic("Couldn't create handle\n");

	rc = gpfPipelineSetup(handle);
	if (rc < 0) gpfPanic("Couldn't setup pipeline\n");

	gpfClearProperties(&props);
	gpfSetFlags(&props, GPF_FRAME_FIRST);
	gpfSetProperties(handle, &props);


	printf("start data-transfer\n");
	gpfStartStream(handle);

	x = y = 0;
	xstep = ystep = 5;

	while (!gpfIsStopped(handle) && !ggiKbhit(vis)) {
		gpfTransferNextStreamBlock(handle, NULL);
		do_scroll(vis, &mode, &x, &y, &xstep, &ystep);
	}	/* while */

	printf("finished data-transfer\n");

	ggiFlush(vis);

#if 0
	/* Wait for any keypress.
	 * This is a blocking call which returns a 16 bit wide unicode
	 * character
	 */
	(void) ggiGetc(vis);
#else
	while (!ggiKbhit(vis)) {
		do_scroll(vis, &mode, &x, &y, &xstep, &ystep);
		ggiFlush(vis);
	}	/* while */
#endif

	gpfClose(handle);

	return 0;
}	/* do_demo */



int main(int argc, char **argv)
{
	ggi_visual_t vis;
	char *filename;

#ifdef USE_PARAMS
	if (argc < 2) {
		printf("Usage: %s file:/<path>/<filename>.ppm\n", argv[0]);
		return -1;
	}	/* if */
	filename = argv[1];
#else
	filename = "file:./ggi_logo.ppm";
#endif

	printf("Load filename: %s\n", filename);


	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}	/* if */
	
	/* Initialize libGPF */
	if (gpfInit() != 0) {
		ggiPanic("Unable to initialize LibGPF\n");
	}	/* if */

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}	/* if */

	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}	/* if */
	
	/* This fails on non palletted modes, but we ignore this here.
	 */
	ggiSetColorfulPalette(vis);

	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);


	/* Try the API functions */
	do_demo(vis, filename);


	/* Close visual */
	ggiClose(vis);

	/* Deinitialize libGPF */
	gpfExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}	/* main */
