/*
 ******************************************************************************

 LIBGPF: libggi io target header

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_debug.h>
#include <ggi/internal/gpf_helpers.h>

#include <string.h>


/*
 *      "exported" Function prototypes
 */

GPFio_open			GPF_LIBGGI_open;
GPFio_close			GPF_LIBGGI_close;

GPFio_setcurrframe		GPF_LIBGGI_setcurrframe;
GPFio_getcurrframe		GPF_LIBGGI_getcurrframe;
GPFio_getnumframes		GPF_LIBGGI_getnumframes;

GPFio_read			GPF_LIBGGI_read;
GPFio_write			GPF_LIBGGI_write;

GPFio_doio			GPF_LIBGGI_doio;

GPFpipe_setup			GPF_LIBGGI_setup_input;
GPFpipe_setup			GPF_LIBGGI_setup_output;
GPFpipe_TransferNextStreamBlock	GPF_LIBGGI_transfernextstreamblock_input;
GPFpipe_TransferNextStreamBlock	GPF_LIBGGI_transfernextstreamblock_output;
GPFpipe_getformat		GPF_LIBGGI_getformat;
GPFio_pipe_getinfolist		GPF_LIBGGI_pipe_getinfolist;




/* Structures needed by private structure
 */

enum libggi_opmode_t {
	OPMODE_FRAME =	1,
	OPMODE_HLINE =	2,
	OPMODE_VLINE =	3,
};



/* Structure holding private data.
 */
struct libggigpf_priv {
	ggi_visual_t vis;
	enum libggi_opmode_t opmode;
	ggi_mode mode;
	int flush;

	struct gpf_pixelformat_t pf;

	uint32 nr;
	uint32 doconv;

	int openvis;
	char target[GPF_MAXPARAM_LEN];

	int read_xoffset, read_yoffset;
	int write_xoffset, write_yoffset;

	void *buf;
	size_t bufsize;
};

#define LIBGGI_PRIV(io)	\
		((struct libggigpf_priv *)(LIBGPF_IO_PRIVATE(io)))
