/*
 ******************************************************************************

 LIBGPF: ppm io target header

 Copyright (C) 2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_debug.h>
#include <ggi/internal/gpf_helpers.h>

#include <string.h>


/*
 *      "exported" Function prototypes
 */

GPFio_open			GPF_PPM_open;
GPFio_close			GPF_PPM_close;

GPFio_setcurrframe		GPF_PPM_setcurrframe;
GPFio_getcurrframe		GPF_PPM_getcurrframe;
GPFio_getnumframes		GPF_PPM_getnumframes;

GPFio_read			GPF_PPM_read;
GPFio_write			GPF_PPM_write;


GPFpipe_setup			GPF_PPM_setup_input;
GPFpipe_setup			GPF_PPM_setup_output;
GPFpipe_TransferNextStreamBlock	GPF_PPM_transfernextstreamblock_input;
GPFpipe_TransferNextStreamBlock	GPF_PPM_transfernextstreamblock_output;
GPFpipe_getformat		GPF_PPM_getformat;
GPFio_pipe_getinfolist		GPF_PPM_pipe_getinfolist;


struct ppmgpf_priv;

typedef ssize_t (PPM_conv)(struct ppmgpf_priv *priv,
			void *buf_in, void *buf_out,
			size_t size_in, size_t size_out);

typedef int (PPM_is_frame_finished)(struct ppmgpf_priv *priv,
				struct gpf_pipeline_item_t *pipe);


PPM_conv			GPF_PPM_conv_8to16;
PPM_conv			GPF_PPM_conv_16to8;

PPM_is_frame_finished		_ppm_input_is_frame_finished;
PPM_is_frame_finished		_ppm_output_is_frame_finished;


enum ppm_opmode_t {
	OPMODE_FRAME =	1,
	OPMODE_HLINE =	2,
	OPMODE_VLINE =	3,
};

enum ppm_format_t {
	PPM_FORMAT_P3 =	1,
	PPM_FORMAT_P6 = 4, 
};



#define MAX_LINELEN     2048
#define COMMENT_CHAR    '#'
#define QUOTE_CHARS     "'\""

#define SKIPWHITE(str)  {while (isspace((int)*(str)) && *(str) != '\0' \
				&& *(str) != COMMENT_CHAR) { (str)++; }}
#define SKIPNONWHITE(str) {while (!isspace((int)*(str)) && *(str) != '\0' \
				&& *(str) != COMMENT_CHAR) { (str)++; }}
#define SKIPTOEND(str)  {while (*(str) != '\0' && *(str) != '\n' \
				&& *(str) != COMMENT_CHAR) { (str)++; }}


/* Structure holding private data.
 */
struct ppmgpf_priv {
	enum ppm_opmode_t opmode;
	enum ppm_format_t format;

	int width, height, bitdepth, depth;
	int bypp;	/* bytes per pixel */

	struct gpf_pixelformat_t pf;

	int read_xoffset, read_yoffset;
	int write_xoffset, write_yoffset;

	int max_frames;

	PPM_is_frame_finished	*is_frame_finished;
	PPM_conv		*func_conv;

	uint32 nr;
	uint32 doconv;

	void *buf;
	size_t bufsize;
};

#define PPM_PRIV(io)		\
		((struct ppmgpf_priv *)(LIBGPF_IO_PRIVATE(io)))
