/*
 ******************************************************************************

 LIBGPF: <sample> io target pre/post conversion functions

 Copyright (C) 2002 <Author>     [<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"


ssize_t GPF_<sample>_transfernextstreamblock_input(gpf_handle_t handle,
					struct gpf_pipeline_item_t *pipe,
					size_t transfer_size)
{
	ssize_t rc;
	struct gpf_pipeline_t *pipeline = NULL;
	struct gpf_handle_opio_t *opio = NULL;
	struct <sample>gpf_priv *priv = NULL;

	LIB_ASSERT(handle != NULL);
	LIB_ASSERT(pipe != NULL);

	GPFDPRINT_TRANSFER("io-<sample> (input): used in handle: %p, pipe: %p\n",
			handle, pipe);

	pipeline = handle->pipeline;
	opio = handle->opio_input;
	priv = <sample>_PRIV(opio);

	LIB_ASSERT(PIPE_READBUF(pipe) != NULL);
	LIB_ASSERT(PIPE_READBUFSIZE(pipe) > 0);
	LIB_ASSERT(PIPE_WRITEBUF(pipe) != NULL);
	LIB_ASSERT(PIPE_WRITEBUFSIZE(pipe) > 0);

	LIMIT_TRANSFERSIZE;

	LIB_ASSERT(pipe->buf_conv == NULL);
	LIB_ASSERT(pipe->buf_conv_size == 0);
	pipe->buf_conv = PIPE_READBUF(pipe);
	pipe->buf_conv_size = PIPE_READBUFSIZE(pipe);

	rc = opio->read(opio, (PIPE_READBUF(pipe) + PIPE_READCACHESIZE(pipe)),
			transfer_size - PIPE_READCACHESIZE(pipe));
	if ((rc == 0) && (PIPE_READCACHESIZE(pipe) == 0)) {
		handle->pipe_index = NULL;
		goto exit;
	}	/* if */
	if (rc < 0) {
		goto exit;
	}	/* if */

	pipe->readbytes = rc;
	PIPE_WRITEBUFPOS(pipe) = PIPE_WRITECACHESIZE(pipe);

	GPFDPRINT_TRANSFER("io-<sample> (input): %i bytes read, %i bytes are cached, try %i bytes to write\n",
			pipe->readbytes, PIPE_READCACHESIZE(pipe),
			pipe->readbytes + PIPE_READCACHESIZE(pipe));

	rc = pipeline->write(pipe,
			pipe->readbytes + PIPE_READCACHESIZE(pipe),
			PIPE_WRITEBUFSIZE(pipe));
	if (rc < 0) {
		GPFDPRINT("io-libggi (input): error %i occured during write\n", rc);
		goto exit;
	}	/* if */

	pipe->writebytes = rc;
	GPFDPRINT_TRANSFER("io-<sample> (input): %i bytes finally written, %i bytes to cache\n",
			pipe->writebytes, pipe->readbytes - pipe->writebytes);

	if (pipe->readbytes > pipe->writebytes) {
		PIPE_READCACHEDATA(pipe, pipe->readbytes - pipe->writebytes);
	}	/* if */
	PIPE_READBUFPOS(pipe) = 0;

	handle->pipe_index = handle->pipe_index->next;

exit:
	pipe->buf_conv = NULL;
	pipe->buf_conv_size = 0;

	return rc;
}	/* GPF_<sample>_transfernextstreamblock_input */



ssize_t GPF_<sample>_transfernextstreamblock_output(gpf_handle_t handle,
					struct gpf_pipeline_item_t *pipe,
					size_t transfer_size)
{
	ssize_t rc;
	size_t tmp_size;
	struct gpf_handle_opio_t *opio = NULL;
	struct gpf_pipeline_t *pipeline = NULL;
	struct <sample>gpf_priv *priv = NULL;

	LIB_ASSERT(handle != NULL);
	LIB_ASSERT(pipe != NULL);

	GPFDPRINT_TRANSFER("io-libggi (output): used in handle: %p, pipe: %p\n",
			handle, pipe);

	pipeline = handle->pipeline;
	opio = handle->opio_output;
	priv = <sample>_PRIV(opio);

	LIB_ASSERT(PIPE_READBUF(pipe) != NULL);
	LIB_ASSERT(PIPE_READBUFSIZE(pipe) > 0);


	GET_TARGET_TRANSFERSIZE;
	LIMIT_TRANSFERSIZE;


	/* make sure, that transfer_size is actually what you want. Sometimes
	 * you must change it and use another variable, i.e. write_size
	 */
	REALLOC_BUFCONVSIZE(transfer_size);

	GPFDPRINT_TRANSFER("io-<sample> (output): try to transfer %i bytes, %i bytes are cached\n",
			transfer_size, PIPE_READCACHESIZE(pipe));
	GPFDPRINT_TRANSFER("io-<sample> (output): %i bytes in read buffer (minus cached bytes)\n",
			PIPE_WRITEBUFPOS(pipe->prev));


	tmp_size = transfer_size;
	PIPE_READBUFPOS(pipe) = 0;
	do {
		rc = pipeline->read(pipe, tmp_size, transfer_size);
		if (rc < 0) {
			fprintf(stderr, "io-<sample> (output): error %i during reading occured\n",
				rc);
			return rc;
		}	/* if */
		if (rc == 0) break;     /* ready? */

		pipe->readbytes += rc;
		GPFDPRINT_TRANSFER("io-<sample> (output): %i bytes were read, now try to write them\n", rc);

		/* performs conversion if needed */
		rc = opio->write(opio, pipe->buf_conv, rc);
		if (rc < 0) {
			fprintf(stderr, "io-<sample> (output): error %i during writing occured\n",
				rc);
			return rc;
		}	/* if */

		GPFDPRINT_TRANSFER("io-<sample> (output): %i bytes written\n", rc);

		pipe->writebytes += rc;
		tmp_size -= rc;
	} while (rc > 0);

	rc = pipe->writebytes;

	GPFDPRINT_TRANSFER("io-<sample> (output): %i bytes transfered, %i bytes must be cached\n",
			pipe->writebytes, PIPE_WRITEBUFPOS(pipe->prev) - pipe->writebytes);

	if (PIPE_WRITEBUFPOS(pipe->prev) < pipe->writebytes) {
		PIPE_READCACHEDATA(pipe, pipe->writebytes -
				PIPE_WRITEBUFPOS(pipe->prev) +
				PIPE_READCACHESIZE(pipe));
	} else {
		PIPE_READCACHEDATA(pipe,
				PIPE_WRITEBUFPOS(pipe->prev) -
				pipe->writebytes);
	}	/* if */

	if (PIPE_WRITEBUFPOS(pipe->prev) <= pipe->writebytes) {
		handle->pipe_index = handle->pipe_index->prev;
		pipe->readbytes = pipe->writebytes = 0;
	}	/* if */

	GPFDPRINT_TRANSFER("io-<sample> (output): %i bytes cached\n",
		PIPE_READCACHESIZE(pipe));

	return rc;
}	/* GPF_<sample>_transfernextstreamblock_output */





#warning Add your own conversion routines here, you defined in <sample>_gpf.h


/* These two conversion functions are only implementation examples!
 * Change them to your own needs.
 * See the <sample>_gpf.h file for the prototype declaration.
 */

ssize_t GPF_<sample>_conv_<func1>(struct <sample>gpf_priv *priv,
                        void *buf_in, void *buf_out,
                        size_t size_in, size_t size_out)
{
	ssize_t rc = 0;
	size_t conv_bytes;
	char *bufc_in;
	short *bufc_out;

	if (size_out < 2) return 0;

	bufc_in = (char *)buf_in;
	bufc_out = (short *)buf_out;

	conv_bytes = size_in;
	while (conv_bytes--) {
		bufc_out[0] = (unsigned short)(bufc_in[0] << 8 | bufc_in[0]);
		bufc_in++;
		bufc_out++;
		size_out -= 2;

		if ((size_out == 0) && (conv_bytes > 0)) {
			rc = size_in - conv_bytes;

			GPFDPRINT_TARGET("%s:%s:%i: output buffer not large"
					" enough to complete conversion (%u,%i)\n",
					DEBUG_INFO, size_in, rc);
			return rc;
		}	/* if */
	}	/* while */

	rc = size_in - conv_bytes;
	return rc;
}	/* GPF_<sample>_conv_<func1> */


ssize_t GPF_<sample>_conv_<func2>(struct <sample>gpf_priv *priv,
			void *buf_in, void *buf_out,
			size_t size_in, size_t size_out)
{
	ssize_t rc = 0;
	size_t conv_bytes;
	short *bufc_in;
	char *bufc_out;

	if (size_out < 1) return 0;

	bufc_in = (short *)buf_in;
	bufc_out = (char *)buf_out;

	conv_bytes = size_in;
	while (conv_bytes--) {
		bufc_out[0] = (unsigned char)(bufc_in[0] >> 8);
		bufc_in++;
		bufc_out++;
		size_out--;
		conv_bytes -= 2;

		if ((size_out == 0) && (conv_bytes > 0)) {
			rc = size_in - conv_bytes;

			GPFDPRINT_TARGET("%s:%s:%i: output buffer not large"
					" enough to complete conversion (%u,%i)\n",
					DEBUG_INFO, size_in, rc);
			return rc;
		}	/* if */
	}	/* while */

	rc = size_in - conv_bytes;
	return rc;
}	/* GPF_<sample>_conv_<func2> */
