/*
 ******************************************************************************

 LIBGPF: <sample> io target functions

 Copyright (C) 2002 <Author>	[<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>



static int open4output(struct gpf_handle_opio_t *opio,
			struct gpf_pipeline_item_t *pipe,
			struct <sample>gpf_priv *priv)
{
	int rc = GGI_OK;

	/* When your target doesn't need two different handlings
	 * to handle the both cases, when it accts as input or output,
	 * then you don't need this function.
	 */

	priv-><width> = opio->pipe->width = pipe->prev->width;
	priv-><height> = opio->pipe->height = pipe->prev->height;
	priv-><depth> = opio->pipe->depth;	/* significant bits per pixel */
	priv-><size> = opio->pipe->size;	/* bits per pixel */


#warning Write the header information here

	/* ... by using opio->proto->write()
	 */

	return GGI_OK;

err0:
	opio->opproto->close(opio);

	GPFDPRINT_TARGET("%s:%s:%i: leave with rc: %i\n",
			DEBUG_INFO, rc);
	return rc;
}	/* open4output */


int GPF_<sample>_open(struct gpf_handle_opio_t *opio)
{
	int rc = GGI_OK;

	struct <sample>gpf_priv *priv;


	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);

	priv = <sample>_PRIV(opio);


	/* When your target doesn't require a distingstion
	 * whether it accts as input or output target,
	 * then you can remove this
	 */
	if (LIBGPF_IO_ISINPUT(opio)) {
		goto read;
	}	/* if */

	if (LIBGPF_IO_ISOUTPUT(opio)) {
		goto write;
	}	/* if */


read:
	rc = opio->opproto->open(opio, <flags>);
	if (rc != GGI_OK) {
		/* Perform error handling here */
	}	/* if */

#warning Read some data here to determine the (pixel-)format you get later


	/* A must: Tell the pipeline management some information
	 * to solve a chicken/egg problem.
	 */
	opio->pipe->width = priv-><width>;
	opio->pipe->height = priv-><height>;
	opio->pipe->depth = priv-><depth>;	/* Significant bits per pixel */
	opio->pipe->size = priv-><size>;	/* Bits per pixel */

	return rc;


write:

	/* If the target doesn't depend on these values you can
	 * remove this if-block
	 */
	if ((opio->pipe->width == 0) || (opio->pipe->height == 0)) {
		/* Ooops! This target is probably opened _before_
		 * the input one. Fail!
		 */
		rc = GGI_ENOMATCH;
		goto err0;
	}	/* if */


	rc = opio->opproto->open(opio, <flags>);
	if (rc != GGI_OK) {
		/* Perform error handling here */
	}	/* if */


	/* Take the information, the target needs here
	 * but has no other/native way to get them.
	 * What isn't needed here can be removed.
	 */
	priv-><width> = opio->pipe->width;
	priv-><height> = opio->pipe->height;
	priv-><depth> opio->pipe->depth;	/* Significant bits per pixel */
	priv-><size> opio->pipe->size;	/* Bits per pixel */

	return rc;

err1:
	opio->opproto->close(opio);
err0:
	GPFDPRINT_TARGET("%s:%s:%i: leave with rc: %i\n",
			DEBUG_INFO, rc);
	return rc;
}	/* GPF_<sample>_open */


int GPF_<sample>_close(struct gpf_handle_opio_t *opio)
{
	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);

	return opio->opproto->close(opio);
}	/* GPF_<sample>_close */




int GPF_<sample>_setcurrframe(struct gpf_handle_opio_t *opio, int num_frame)
{
	int rc = GGI_OK;
	struct <sample>gpf_priv *priv;

	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);
	priv = <sample>_PRIV(opio);

#warning set the framenumber here

	return rc;
}	/* GPF_<sample>_setcurrframe */


int GPF_<sample>_getcurrframe(struct gpf_handle_opio_t *opio, int *num_frame)
{
	int rc = GGI_OK;
	struct <sample>gpf_priv *priv;

	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);
	priv = <sample>_PRIV(opio);


#warning return the current frame number being processed here

	return rc;
}	/* GPF_<sample>_getcurrframe */


int GPF_<sample>_getnumframes(struct gpf_handle_opio_t *opio, int *num_frames)
{
	int rc = GGI_OK;
	struct <sample>gpf_priv *priv;

	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);
	priv = <sample>_PRIV(opio);

#warning return the total number of frames

	return rc;
}	/* GPF_<sample>_getnumframes */




ssize_t GPF_<sample>_read(struct gpf_handle_opio_t *opio,
			void *buf, size_t size)
{
	ssize_t rc;
	struct <sample>gpf_priv *priv;

	GPFDPRINT_TARGET("%s:%s:%i: opio: %p, buf: %p, size: %i\n",
			DEBUG_INFO, opio, buf, size);
	priv = <sample>_PRIV(opio);


	/* Read the data here */
	if (priv->doconv) {
		/* Here conversion is performed 
		 */

		/* Attention:
		 *
		 * priv->buf and priv->bufsize doesn't exist by default
		 * in the priv structure. Either you add them there or you
		 * declare some temp buffer variables here
		 */

		rc = opio->opproto->read(opio, priv->buf,
					priv->bufsize);
		if (rc < 0) {
			/* error occured */
			goto exit;
		}	/* if */


		/* Attention:
		 *
		 * If you priv->func_conv changed the func_conv prototype in
		 * <sample>_gpf.h, you must change that function call here.
		 * Otherwise the compiler fails here.
		 * See the <sample>_gpf.h file for more details.
		 */
		rc = priv->func_conv(priv, priv->buf, buf,
					priv->bufsize, size);
	} else {
		/* No conversion is required here
		 */

		rc = opio->opproto->read(opio, buf, size);

		fprintf(stderr, "%s:%s:%i: rc: %i\n",
			DEBUG_INFO, rc);
		if (rc < 0) {
			/* error occured */
			goto exit;
		}	/* if */
	}	/* if */


exit:
	return rc;
}	/* GPF_<sample>_read */


ssize_t GPF_<sample>_write(struct gpf_handle_opio_t *opio,
			void *buf, size_t size)
{
	ssize_t rc;
	struct <sample>gpf_priv *priv;

	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);
	priv = <sample>_PRIV(opio);

	if (priv->doconv) {
		/* Here conversion is performed 
		 */

		/* Attention:
		 *
		 * priv->buf and priv->bufsize doesn't exist by default
		 * in the priv structure. Either you add them there or you
		 * declare some temp buffer variables here
		 */

		/* Attention:
		 *
		 * If you priv->func_conv changed the func_conv prototype in
		 * <sample>_gpf.h, you must change that function call here.
		 * Otherwise the compiler fails here.
		 * See the <sample>_gpf.h file for more details.
		 */
		rc = priv->func_conv(priv, buf, priv->buf,
					size, priv->bufsize);
		if (rc < 0) {
			/* an error occured */
			return rc;
		}	/* if */

		rc = opio->opproto->write(opio, priv->buf, priv->bufsize);
	} else {
		rc = opio->opproto->write(opio, buf, size);
	}	/* if */

	return rc;
}	/* GPF_<sample>_write */




static int GPF_<sample>_perform_conversion(struct <sample>gpf_priv *priv)
{
	LIB_ASSERT(priv != NULL);


	switch (priv->nr) {
	case 0:
		/* This is format1 this target supports
		 * See the pipe.c file for more details.
		 */

		/* That means, no conversion is needed */
		return 0;

		/* That means, no conversion is needed */
		return 1;

	case 1:
		/* This is format2 this target supports */

		/* That means, no conversion is needed */
		return 0;

		/* That means, no conversion is needed */
		return 1;
	}	/* switch */

	LIB_ASSERT(priv->nr < 2);
	return 0;
}	/* GPF_<sample>_perform_conversion */




int GPF_<sample>_setup_input(gpf_handle_t handle,
			struct gpf_pipeline_item_t *pipe)
{
	int rc;
	size_t data_size;
	struct <sample>gpf_priv *priv = NULL;
	struct gpf_pipeline_t *pipeline = NULL;

	LIB_ASSERT(handle != NULL);
	LIB_ASSERT(pipe != NULL);

	pipeline = handle->pipeline;
	priv = <sample>_PRIV(handle->opio_input);

	LIB_ASSERT(PIPE_READBUF(pipe) == NULL);
	LIB_ASSERT(PIPE_WRITEBUF(pipe) == NULL);

	GPFDPRINT("io-<sample> (input): setting it up to act as input target\n");

#warning Tell the pipeline the resolution of the image here

	/* You should know that here, as you already opened
	 * the data-stream in GPF_<sample>_open
	 */

	LIB_ASSERT(pipe->width > 0);
	LIB_ASSERT(pipe->height > 0);

	LIB_ASSERT(PIPELINEITEM_MARK(pipe, INFOLIST_INPUT) != NULL);
	LIB_ASSERT(PIPELINEITEM_MARK(pipe, INFOLIST_OUTPUT) == NULL);

	memcpy(&priv->pf, &PIPELINEITEM_MARK(pipe, INFOLIST_INPUT)->pf,
		sizeof(struct gpf_pixelformat_t));
	priv->nr = PIPELINEITEM_MARK(pipe, INFOLIST_INPUT)->nr;


	data_size = pipe->width * pipe->height * <bytes_per_pixel>;
	LIB_ASSERT(data_size > 0);

	/* the amount of memory, that we have to transfer */
	rc = _gpf_alloc_readbuf(pipe, data_size);
	if (rc != GGI_OK) {
		GPFDPRINT("%s:%s:%i: io-<sample> (input): memory allocation failed\n",
			DEBUG_INFO);
		goto err0;
	}	/* if */

	rc = _gpf_alloc_writebuf(pipe, data_size);
	if (rc != GGI_OK) {
		GPFDPRINT("%s:%s:%i: io-<sample> (input): memory allocation failed\n",
			DEBUG_INFO);
		goto err1;
	}	/* if */

	LIB_ASSERT(pipe->buf_conv == NULL);
	LIB_ASSERT(pipe->buf_conv_size == 0);

	if (!GPF_<sample>_perform_conversion(priv)) {
		priv->doconv = 0;
		priv->func_conv = NULL;
		return GGI_OK;
	}	/* if */

	priv->doconv = 1;


#warning Set up the right priv->func_conv pointer here


	return GGI_OK;

err1:
	_gpf_free_readbuf(pipe);
err0:
	return GGI_ENOMEM;
}	/* GPF_<sample>_setup_input */



int GPF_<sample>_setup_output(gpf_handle_t handle,
			struct gpf_pipeline_item_t *pipe)
{
	struct <sample>gpf_priv *priv = NULL;
	struct gpf_pipeline_t *pipeline = NULL;

	LIB_ASSERT(handle != NULL);
	LIB_ASSERT(pipe != NULL);

	pipeline = handle->pipeline;
	priv = <sample>_PRIV(handle->opio_output);

	GPFDPRINT("io-<sample> (output): setting it up to act as output target\n");

	LIB_ASSERT(PIPELINEITEM_MARK(pipe, INFOLIST_INPUT) == NULL);
	LIB_ASSERT(PIPELINEITEM_MARK(pipe, INFOLIST_OUTPUT) != NULL);

	memcpy(&priv->pf, &PIPELINEITEM_MARK(pipe, INFOLIST_OUTPUT)->pf,
		sizeof(struct gpf_pixelformat_t));
	priv->nr = PIPELINEITEM_MARK(pipe, INFOLIST_OUTPUT)->nr;



	if (!GPF_PPM_perform_conversion(priv)) {
		GPFDPRINT("io-<sample> (output): performs no conversion\n");
		priv->doconv = 0;
	} else {
		GPFDPRINT("io-<sample> (output): conversion enabled\n");
		priv->doconv = 1;
	}	/* if */

	return GGI_OK;
}	/* GPF_<sample>_setup_output */


int GPF_<sample>_getformat(struct gpf_pipeline_item_t *pipe,
			struct gpf_pipeline_item_t *from_pipe,
			int chain)
{
	GPFDPRINT_PIPEMGR("io-<sample>: <replace me: Either it relies on foreign format descriptions or not>\n");

	return GGI_OK;
}	/* GPF_<sample>_getformat */

