/*
 ******************************************************************************

 LIBGPF: <sample> pipe initialisation

 Copyright (C) 2002 <Author>	[<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"
#include <ggi/internal/gpf_internal.h>


/* Currently, the pipe sublib currently don't need any args passed by the
 * pipeline management. But I leave that code as a sort of dummy-code in
 * order to readd it quickly, if it turns out, that it is needed later again.
 */


static const gg_option optlist[] =
{
	{ "dummy", "" },
};

#define OPT_DUMMY	0

#define NUM_OPTS	(sizeof(optlist)/sizeof(gg_option))



static int GPFinit(struct gpf_pipeline_item_t *pipe,
		const char *args, va_list ap)
{
	gg_option options[NUM_OPTS];
	struct <sample>gpf_priv *priv = NULL;

	GPFDPRINT_PIPE("%s:%s:%i: entered\n", DEBUG_INFO);
	GPFDPRINT_PIPE("%s:%s:%i: args (%s)\n", DEBUG_INFO, args);


#if 0
	if (!args || !args[0]) {
		fprintf(stderr, "pipe-<sample>: Missing argument.\n");
		return GGI_EARGREQ;
	}	/* if */
#endif

	memcpy(options, optlist, sizeof(options));
	args = ggParseOptions(args, options, NUM_OPTS);
	if (args == NULL) {
		fprintf(stderr, "pipe-<sample>: error in arguments.\n");
		return GGI_EARGINVAL;
	}	/* if */

	priv = <sample>_PRIV(pipe);

	GPFDPRINT_PIPE("%s:%s:%i: leaving\n", DEBUG_INFO);

	return GGI_OK;
}	/* GPFinit */



static int GPFopen(struct gpf_handle_opio_t *opio,
		   struct gpf_pipeline_item_t *pipe,
		   struct gpf_dlhandle *dlh, const char *args,
		   va_list ap, uint32 *dlret)
{
	int rc;
	struct <sample>gpf_priv *priv;

	GPFDPRINT_LIBS("GPFopen(%p, %p, %p, %s, %p, %p) called for <sample> sublib\n",
		opio, pipe, dlh, args ? args : "(NULL)", ap, dlret);

	LIBGPF_PIPE_PRIVATE(pipe) = malloc(sizeof(struct <sample>gpf_priv));
	if (LIBGPF_PIPE_PRIVATE(pipe) == NULL) return GGI_ENOMEM;


	priv = <sample>_PRIV(pipe);

	memset(priv, 0, sizeof(struct <sample>gpf_priv));

	pipe->setup = GPF_<sample>_setup;
	pipe->getformat = GPF_<sample>_getformat;
	pipe->getinfolist = GPF_<sample>_getinfolist;
	pipe->transfernextstreamblock = GPF_<sample>_transfernextstreamblock;

	rc = GPFinit(pipe, args, ap);
	if (rc != GGI_OK) goto exit;

exit:
	*dlret = (GPF_DL_OPPIPE);
	return rc;
}	/* GPFopen */


static int GPFclose(struct gpf_pipeline_item_t *pipe,
		    struct gpf_dlhandle *dlh)
{
	GPFDPRINT_LIBS("GPFclose(%p, %p) called for <sample> sublib\n",
			pipe, dlh);

	free(LIBGPF_PIPE_PRIVATE(pipe));

	LIBGPF_PIPE_PRIVATE(pipe) = NULL;

	return GGI_OK;
}	/* GPFclose */


int GPFdl_<sample>(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GPFopen;
		return GGI_OK;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return GGI_OK;
	case GGIFUNC_close:
		*funcptr = GPFclose;
		return GGI_OK;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GPFdl_<sample> */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
