/*
 ******************************************************************************

 LIBGPF: <sample> protocol initialisation

 Copyright (C) 2002 <Author>	[<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"
#include <ggi/internal/gpf_internal.h>

#include <string.h>

static int GPFinit(struct gpf_handle_opio_t *opio,
		const char *args, va_list ap)
{
	char *location;


	GPFDPRINT_PROTO("%s:%s:%i: args (%s)\n", DEBUG_INFO, args);

	if (!args || !args[0]) {
#warning Put in an appropriate error-message, if any arguments are required

		fprintf(stderr, "display-<sample>: <Error-Message>.\n");
		return GGI_EARGREQ;
	}	/* if */

	location = <sample>_PRIV(opio)->location;
	memcpy(location, args, strlen(args)+1);

	GPFDPRINT_PROTO("%s:%s:%i: location (%s)\n",
		DEBUG_INFO, <sample>_PRIV(opio)->location);

	return GGI_OK;
}	/* GPFinit */



static int GPFopen(struct gpf_handle_opio_t *opio,
		   struct gpf_pipeline_item_t *pipe,
		   struct gpf_dlhandle *dlh, const char *args,
		   va_list ap, uint32 *dlret)
{
	int rc;
	struct <sample>gpf_priv *priv;


	GPFDPRINT_LIBS("GPFopen(%p, %p, %p, %s, %p, %p) called for <sample> sublib\n",
		opio, pipe, dlh, args ? args : "(NULL)", ap, dlret);

	LIBGPF_PROTO_PRIVATE(opio) = malloc(sizeof(struct <sample>gpf_priv));
	if (LIBGPF_PROTO_PRIVATE(opio) == NULL) return GGI_ENOMEM;

	priv = <sample>_PRIV(opio);

	memset(priv, 0, sizeof(struct <sample>gpf_priv));

	rc = GPFinit(opio, args, ap);

	if (rc == GGI_OK) {
		opio->opproto->open = GPF_<sample>_open;
		opio->opproto->close = GPF_<sample>_close;

		opio->opproto->read = GPF_<sample>_read;
		opio->opproto->write = GPF_<sample>_write;

		opio->opproto->lseek = GPF_<sample>_lseek;
		opio->opproto->flush = GPF_<sample>_flush;
		opio->opproto->eos = GPF_<sample>_eos;
	}	/* if */

	*dlret = (GPF_DL_OPPROTO);
	return rc;
}	/* GPFopen */


static int GPFclose(struct gpf_pipeline_item_t *pipe,
		    struct gpf_dlhandle *dlh)
{
	GPFDPRINT_LIBS("GPFclose(%p, %p) called for <sample> sublib\n",
			pipe, dlh);

	free(LIBGPF_PIPE_PRIVATE(pipe));
	LIBGPF_PIPE_PRIVATE(pipe) = NULL;

	return 0;
}	/* GPFclose */


int GPFdl_<sample>(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GPFopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GPFclose;
		return 0;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GPFdl_<sample> */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
