/*
 ******************************************************************************

 LIBGPF: target protocol initialisation

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "target_gpf.h"
#include <ggi/internal/gpf_internal.h>


static int GPFopen(struct gpf_handle_opio_t *opio,
		   struct gpf_pipeline_item_t *pipe,
		   struct gpf_dlhandle *dlh, const char *args,
		   va_list ap, uint32 *dlret)
{
	int rc;

	GPFDPRINT_LIBS("GPFopen(%p, %p, %p, %s, %p, %p) called for target sublib\n",
		opio, pipe, dlh, args ? (strlen(args) ? args : "\"\"") : "(NULL)",
		ap, dlret);

	LIB_ASSERT(pipe != NULL);
	LIB_ASSERT(opio->opproto != NULL);

	if (opio->doio == NULL) {
		/* This happens, when a target is used, that has
		 * no own methods to access the physical device and the
		 * user forgot to specify a protocol.
		 * So we just give a hint and abort.
		 */

		fprintf(stderr,
			"You forgot to specify a protocol for the transfer\n");
		return GGI_ENOMATCH;
	}	/* if */


	LIBGPF_PROTO_PRIVATE(opio) = malloc(sizeof(struct targetgpf_priv));
	if (LIBGPF_PROTO_PRIVATE(opio) == NULL) return GGI_ENOMEM;

	opio->opproto->is_eos = 0;

	rc = opio->doio(opio, args, ap);

	GPFDPRINT_LIBS("leave target sublib\n");

	*dlret = (GPF_DL_OPPROTO);
	return rc;
}	/* GPFopen */


static int GPFclose(struct gpf_pipeline_item_t *pipe,
		    struct gpf_dlhandle *dlh)
{
	GPFDPRINT_LIBS("GPFclose(%p, %p) called for libggi sublib\n",
			pipe, dlh);

	free(LIBGPF_PIPE_PRIVATE(pipe));
	LIBGPF_PIPE_PRIVATE(pipe) = NULL;

	return 0;
}	/* GPFclose */


int GPFdl_target(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GPFopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GPFclose;
		return 0;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GPFdl_target */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
