/* $Id: mousebutton.c,v 1.1.1.1 2001/04/22 19:03:41 cegger Exp $
******************************************************************************

   This LibGIC module is a very simple parser for PtrButtonPress Events.

   Copyright (C) 1999 Andrew Apted	[andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ggi/gic.h>
#include <ggi/internal/gic_debug.h>


typedef struct mousebutton_data
{
	int button;
  
} MouseButtonData;

static gic_recognizerdriver mycontrols;


static int getbutton(gic_handle_t hand, gic_recognizer *ctrl, gii_event *event,gic_feature *feature,int recnum)
{
	MouseButtonData *but = ctrl->privdata;

	GICDPRINT_LIBS("MouseButton: Button%s %d [want %d].\n",
		(event->any.type == evPtrButtonPress) ?
		"Press" : "Release", event->pbutton.button, but->button);

	if (event->pbutton.button != but->button) {
		return 0;
	}

	gicFeatureActivate(hand, feature,(event->any.type == evPtrButtonPress) ?
		GIC_STATE_MAX : GIC_STATE_MIN , 0, recnum);
	return 1;
}

static int mbutton_check(gic_handle_t hand, gic_recognizer *ctrl,gii_event *event,gic_feature *feature,int recnum)
{
	GICDPRINT_LIBS("MouseButton: Check with %p,%p.\n",ctrl,event);

	if ((event->any.type == evPtrButtonPress) ||
	    (event->any.type == evPtrButtonRelease)) {
		return getbutton(hand, ctrl, event, feature, recnum);
	}

	return 0;
}

static int mbutton_register(gic_handle_t hand, gic_recognizer **ctrl,MouseButtonData *but,gic_state state)
{
	gic_recognizer *new_rec, *rl;
	MouseButtonData *new_but;
	
	for (rl=*ctrl; rl != NULL; rl=rl->next) {

		MouseButtonData *cur = (MouseButtonData *) rl->privdata;

		if (cur->button == but->button) {

			/* Duplicate entry -- just update the confidence
			 * value.
			 */
			 if (state > rl->confidence) {
			 	rl->confidence = state;
				/* !!! MOVE UP */
			}

			return 1;
		}
	}

	if (NULL==(new_rec=malloc(sizeof(gic_recognizer )))) return -1;
	if (NULL==(new_but=malloc(sizeof(MouseButtonData)))) { free(new_rec); return -1;}
	
	memcpy(new_but, but, sizeof(MouseButtonData));

	new_rec->driver     = &mycontrols;
	new_rec->confidence = state;
	new_rec->privdata   = new_but;
	
	gicRecognizerTrainAdd(hand, ctrl, new_rec);
	
	return 1;
}


static struct trainingstate {
	int got_button;  /* -1 when no current button */
} trainingstate;

static int mbutton_train(gic_handle_t hand, gic_recognizer **ctrl, gii_event *event)
{
	int rc;
	GICDPRINT_LIBS("MouseButton: Training with %p,%p.\n",ctrl,event);

	rc=0;
	if (event == NULL) {

		trainingstate.got_button = -1;

		GICDPRINT_LIBS("MouseButton: Initialized training state.\n");

		return 0;
	}

	GICDPRINT_LIBS("MouseButton: Analyzing event ...\n");

	if (event->any.type == evPtrButtonPress) {

		trainingstate.got_button = event->pbutton.button;

		GICDPRINT_LIBS("MouseButton: Remembered button %d ...\n",
			    trainingstate.got_button);
		
		return 0;
	}

	if ((event->any.type == evPtrButtonRelease) &&
	    (event->pbutton.button = trainingstate.got_button)) {

		MouseButtonData but;

		but.button = trainingstate.got_button;

		rc+=mbutton_register(hand, ctrl, &but, GIC_STATE_MAX);

		GICDPRINT_LIBS("MouseButton: Registered button %d ...\n",
			    trainingstate.got_button);
		
		return rc;
	}

	return rc;
}
 
static int mbutton_write_pvtdata(gic_handle_t hand, gic_recognizer *ctrl,char *string,int maxlen)
{
	MouseButtonData *but = ctrl->privdata;

	if (maxlen < 20) {
		*string='\0';
		return -1;
	}

	sprintf(string, "%d", but->button);

	return 0;
}

static int mbutton_read_pvtdata(gic_handle_t hand, gic_recognizer *ctrl,const char *string)
{
	MouseButtonData *but;

	but = ctrl->privdata = malloc(sizeof(MouseButtonData));

	if (but == NULL) {
		return -1;
	}
	
	sscanf(string, "%i", &but->button);

	return 0;
}

static void mbutton_free_pvtdata(gic_handle_t hand, gic_recognizer *ctrl)
{
	MouseButtonData *but = ctrl->privdata;

	free(but);
	ctrl->privdata = NULL;
	
	return;
}

static int mbutton_get_name(gic_handle_t hand, gic_recognizer *ctrl,char *string,int maxlen)
{
	MouseButtonData *but = ctrl->privdata;

	char namebuf[40];
	
	if (maxlen>20) maxlen=20;

	if (maxlen<=1) {
		/* The user must be Joking ... */
	} else if (maxlen<=5) {
		sprintf(namebuf, "M%.*s%d",maxlen-2,"But",but->button);
	} else if (maxlen<=9) {
		sprintf(namebuf, "%.*sBut%d",maxlen-4,"Mouse", but->button);
	} else
		sprintf(namebuf, "Mouse%.*s%d",maxlen-6,"Button", but->button);
	
	strncpy(string, namebuf, maxlen);

	return 0;
}

static int mbutton_check_conflict(gic_handle_t hand, gic_recognizer *ctrl,gic_recognizer *ctrl2)
{
	MouseButtonData *but1 = ctrl ->privdata;
	MouseButtonData *but2 = ctrl2->privdata;

	if (ctrl == ctrl2) {
		return GIC_C_ISSAME;
	}

	if (ctrl->driver != ctrl2->driver) {
		return GIC_C_NOCONFLICT;
	}

	if (but1->button == but2->button) {
		return GIC_C_ISSAME;
	}

	return GIC_C_NOCONFLICT;
}

int	mbutton_get_opposite (gic_handle_t hand, gic_recognizer *recognizer,gic_recognizer **opposite)
{
	return -1;	/* FIXME */
}


static gic_recognizerdriver mycontrols =
{
	"MouseButton",
	mbutton_check,
	mbutton_get_name,
	mbutton_write_pvtdata,
	mbutton_read_pvtdata,
	mbutton_free_pvtdata,
	mbutton_train,
	mbutton_check_conflict,
	mbutton_get_opposite
};

gic_recognizerdriver *GICdlinit(void)
{
	return &mycontrols;
}
