/*
******************************************************************************

   Demo of the GPF library.

   Authors:	2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]
  
   This code is placed in the public domain and may be used freely for any
   purpose.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/ggi.h>
#include <ggi/gpf.h>


static int do_demo(ggi_visual_t vis)
{
	int rc;
	gpf_handle_t handle;
	struct gpf_properties_t props;
	ggi_visual_t vismem = NULL;
	ggi_mode mode;
	ggi_color yellow = { 0xFFFF, 0xFFFF, 0x0000, 0xFFFF };
	ggi_color red = { 0xFFFF, 0x0000, 0x0000, 0xFFFF };
	ggi_color green = { 0x0000, 0xFFFF, 0x0000, 0xFFFF };
	ggi_color blue = { 0x0000, 0x0000, 0xFFFF, 0xFFFF };
	ggi_color white = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };


	vismem = ggiOpen("memory");

	fprintf(stderr, "gpftest: vis, vismem (%p, %p)\n", vis, vismem);

	ggiGetMode(vis, &mode);

	mode.size.x = mode.size.y = GGI_AUTO;
	mode.graphtype = GT_16BIT;
	ggiCheckMode(vismem, &mode);
	ggiSetMode(vismem, &mode);


	handle = gpfOpen("libggi","-vis=%p", 
			"libggi", "-vis=%p", vismem, vis);

	if (!handle) gpfPanic("Couldn't create handle\n");

	rc = gpfPipelineSetup(handle);
	if (rc < 0) gpfPanic("Couldn't setup pipeline\n");


	/* draw a white rectangle to the memory visual */
	ggiSetGCForeground(vismem, ggiMapColor(vismem, &yellow));
	ggiFillscreen(vismem);
	ggiSetGCForeground(vismem, ggiMapColor(vismem, &red));
	ggiDrawBox(vismem, 0,0, 100,200);
	ggiSetGCForeground(vismem, ggiMapColor(vismem, &green));
	ggiDrawBox(vismem, 100,0, 100,200);
	ggiSetGCForeground(vismem, ggiMapColor(vismem, &blue));
	ggiDrawBox(vismem, 200,0, 100,200);
	ggiSetGCForeground(vismem, ggiMapColor(vismem, &white));
	ggiDrawBox(vismem, 300,0, 100,200);
	ggiFlush(vismem);

	gpfClearProperties(&props);
	gpfSetFlags(&props, GPF_TIMESTAMP_FIRST);
	gpfSetProperties(handle, &props);

	printf("start data-transfer\n");
	gpfStartStream(handle);

	while (!gpfIsStopped(handle) && !ggiKbhit(vis)) {
		gpfTransferNextStreamBlock(handle, NULL);
	}	/* while */

	printf("finished data-transfer\n");

	ggiFlush(vis);


	/* Wait for any keypress.
	 * This is a blocking call which returns a 16 bit wide unicode
	 * character
	 */
	(void) ggiGetc(vis);


	ggiClose(vismem);

	gpfClose(handle);

	return 0;
}	/* do_demo */



int main(void)
{
	ggi_visual_t vis;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}	/* if */
	
	/* Initialize libGPF */
	if (gpfInit() != 0) {
		ggiPanic("Unable to initialize LibGPF\n");
	}	/* if */

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}	/* if */

	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}	/* if */

	/* This fails on non palletted modes, but we ignore this here.
	 */
	ggiSetColorfulPalette(vis);
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	

	/* Try the API functions */
	do_demo(vis);


	/* Close visual */
	ggiClose(vis);

	/* Deinitialize libGPF */
	gpfExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}	/* main */
