/*
******************************************************************************

   LibGPF API header file

   Copyright (C) 2000      Andreas Beck		[becka@ggi-project.org]
   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/


#ifndef _GPF_STRUCTS_H
#define _GPF_STRUCTS_H


#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>


#define GPF_AUTO		GGI_AUTO

enum gpf_flags {
	GPF_REQUEST_MASK	= 0xFFFFFFFF,
	GPF_RESPONSE_MASK	= 0xFFFFFFFF,


	GPF_TIMESTAMP_MASK	= 0x0000000F,

	/* start/continue playing starting with current
	 * timestamp (default)
	 */
	GPF_TIMESTAMP_CONTINUE	= 0x00000001,

	/* start/continue playing starting with first
	 * timestamp
	 */
	GPF_TIMESTAMP_FIRST	= 0x00000002,

	/* may skip frames, if necessary */
	GPF_TIMESTAMP_MAYSKIP	= 0x00000004,



	GPF_PIPE_MASK		= 0x000000F0,

	/* optimize pipeline for as less
	 * memory requirement as possible
	 */
	GPF_PIPE_OPT4MEMORY	= 0x00000010,

	/* optimize pipeline for speed
	 * (default behaviour)
	 */
	GPF_PIPE_OPT4SPEED	= 0x00000020,

	/* need realtime capabilities */

	GPF_PIPE_REALTIME	= 0x00000040,



	/* transferrate is given in how many
	 * timestamps per second to play
	 */
};



struct gpf_properties_t {
	uint32 flags;

	/* how many timestamps to play per
	 * second. Lower value means slower
	 * playing and higher value means
	 * faster playing.
	 * Negative value means playing
	 * backward (fails if not supported).
	 */
	struct timeval timestamp_inc;

	/* ratio of speed/memory usage
	 * of the pipeline.
	 */
	double speed_memory_ratio;
};




enum gpf_colorformat_t {
	GPF_CF_RGBA	= 0,	/* rgba/bgra format */
	GPF_CF_YUV	= 1,	/* yuv (4:4:4, 4:2:2, 4:2:1) format */
	GPF_CF_YIQ	= 2,	/* yiq format */
	GPF_CF_YCbCr	= 3,	/* ycbcr (= Kodak PhotoCD) format */
};


typedef struct {
	enum gpf_colorformat_t cf;

	union {
		ggi_color rgba;
		/* TODO: Add types for YUV, YIQ and YCbCr */
	} type;
} gpf_color;


struct gpf_rgba_format_t {

	/*
	 * Simple and common things first :
	 *
	 * Usage of the mask/shift pairs:
	 * If new_value is the _sizeof(ggi_pixel)*8bit_ value of the thing
	 * you want to set, you do
	 *
	 * *pointer &= ~???_mask;	// Mask out old bits
	 * *pointer |= (new_value>>shift) & ???_mask;
	 *
	 * The reason to use 32 bit and "downshifting" is alignment
	 * and extensibility. You can easily adjust to other datasizes
	 * with a simple addition ...
	 */

	/* Simple colors:
	 */
	ggi_pixel	red_mask;	/* Bitmask of red bits */
	int		red_shift;	/* Shift  for red bits */

	ggi_pixel	green_mask;	/* Bitmask of green bits */
	int		green_shift;	/* Shift  for green bits */

	ggi_pixel	blue_mask;	/* Bitmask of blue bits */
	int		blue_shift;	/* Shift  for blue bits */

	ggi_pixel	alpha_mask;	/* Bitmask of alphachannel bits */
	int		alpha_shift;	/* Shift  for alpha bits */
};


struct gpf_yuv_format_t {
	unsigned char	y_mask[8];	/* 8 byte bitmask of y bits */
	int		y_shift;	/* Shift for y bits */

	ggi_pixel	u_mask;		/* 4 byte bitmask of u bits */
	int		u_shift;	/* Shift for u bits */

	ggi_pixel	v_mask;		/* 4 byte bitmask of v bits */
	int		v_shift;	/* Shift for v bits */
};


struct gpf_yiq_format_t {
	unsigned char	y_mask[8];	/* 8 byte bitmask of y bits */
	int		y_shift;	/* Shift for y bits */

	ggi_pixel	i_mask;		/* 4 byte bitmask of i bits */
	int		i_shift;	/* Shift for i bits */

	ggi_pixel	q_mask;		/* 4 byte bitmask of q bits */
	int		q_shift;	/* Shift for q bits */
};


struct gpf_ycbcr_format_t {
	unsigned char	y_mask[8];	/* 8 byte bitmask of y bits */
	int		y_shift;	/* Shift for y bits */

	ggi_pixel	cb_mask;	/* 4 byte bitmask of Cb bits */
	int		cb_shift;	/* Shift for Cb bits */

	ggi_pixel	cr_mask;	/* 4 byte bitmask of Cr bits */
	int		cr_shift;	/* Shift for Cr bits */
};



struct gpf_pixelformat_t {
	int		depth;		/* Number of significant bits */
	int		size;		/* Physical size in bits */

	enum gpf_colorformat_t cf;
	int flags;	/* for internal use - no meaning otherwise */

	union {
		struct gpf_rgba_format_t rgba;
		struct gpf_yuv_format_t yuv;
		struct gpf_yiq_format_t yiq;
		struct gpf_ycbcr_format_t ycbcr;
	} type;
};


#endif	/* _GPF_STRUCTS_H */
