/*
 ******************************************************************************

 LIBGPF: <sample> io target initialisation

 Copyright (C) 2002 <author>     [you@there.com]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"
#include <ggi/internal/gpf_internal.h>


static const gg_option optlist[] =
{
#warning add the options here

	{ "sampleoption", "default-value" },
	{ "sampleoption2", "default-value" },
};

#define OPT_SAMPLEOPTION	0
#define OPT_SAMPLEOPTION2	1

#define NUM_OPTS        (sizeof(optlist)/sizeof(gg_option))



static int GPFinit(struct gpf_handle_opio_t *opio,
		   const char *args, va_list ap)
{
	gg_option options[NUM_OPTS];
	char str[GPF_MAXPARAM_LEN];


	GPFDPRINT_TARGET("%s:%s:%i: args (%s)\n", DEBUG_INFO, args);


	if (!args) {
#warning Remove this if-block, if no arguments are required
		/* there are no arguments given */
		return GGI_OK;
	}	/* if */

	memcpy(options, optlist, sizeof(options));
	args = ggParseOptions(args, options, NUM_OPTS);
	if (args == NULL) {
		fprintf(stderr, "io-<sample>: error in arguments.\n");
		return GGI_EARGINVAL;
	}	/* if */

	GPFDPRINT_TARGET("%s:%s:%i: io-<sample> has args.\n",
			DEBUG_INFO);

	if (options[OPT_SAMPLEOPTION].result) {
		GPFDPRINT_TARGET("io-<sample>: sampleoption=\"%s\"\n",
				options[OPT_SAMPLEOPTION].result);

		_gpfParseArgs(options[OPT_SAMPLEOPTION].result, &ap, &str);

		/* Fill in the stuff in the <sample>_PRIV(opio) structure
		 */

	}	/* if */


	if (options[OPT_SAMPLEOPTION2].result) {
		GPFDPRINT_TARGET("io-<sample>: sampleoption2=\"%s\"\n",
				options[OPT_SAMPLEOPTION2].result);

		_gpfParseArgs(options[OPT_SAMPLEOPTION2].result, &ap, &str);

		/* Fill in the stuff in the <sample>_PRIV(opio) structure
		 */
	}	/* if */

	GPFDPRINT_TARGET("%s:%s:%i: leaving\n", DEBUG_INFO);

	return GGI_OK;
}	/* GPFinit */



static int GPFopen(struct gpf_handle_opio_t *opio,
		   struct gpf_pipeline_item_t *pipe,
		   struct gpf_dlhandle *dlh, const char *args,
		   va_list ap, uint32 *dlret)
{
	int rc;
	struct <sample>gpf_priv *priv;

	GPFDPRINT_LIBS("GPFopen(%p, %p, %p, %s, %p, %p) called for <sample> sublib\n",
		opio, pipe, dlh, args ? args : "(NULL)", ap, dlret);

	LIBGPF_IO_PRIVATE(opio) = malloc(sizeof(struct <sample>gpf_priv));
	if (LIBGPF_IO_PRIVATE(opio) == NULL) return GGI_ENOMEM;


	priv = <sample>_PRIV(opio);

	/* Initialize the priv structure with zeros, because
	 * uninitialized values may cause crashes in threaded applications
	 */
	memset(priv, 0, sizeof(struct <sample>gpf_priv));

#warning Set non-zero default values in the priv structure here


	rc = GPFinit(opio, args, ap);

	if (rc == GGI_OK) {
		opio->open = GPF_<sample>_open;
		opio->close = GPF_<sample>_close;

		opio->setcurrframe = GPF_<sample>_setcurrframe;
		opio->getcurrframe = GPF_<sample>_getcurrframe;
		opio->getnumframes = GPF_<sample>_getnumframes;

		opio->read = GPF_<sample>_read;
		opio->write = GPF_<sample>_write;

		opio->pipe->getformat = GPF_<sample>_getformat;
		opio->pipe_getinfolist = GPF_<sample>_pipe_getinfolist;

		if (opio->type & GPF_DLTYPE_INPUT) {
			opio->pipe->setup = GPF_<sample>_setup_input;
			opio->pipe->transfernextstreamblock
				= GPF_<sample>_transfernextstreamblock_input;
		}	/* if */

		if (opio->type & GPF_DLTYPE_OUTPUT) {
			opio->pipe->setup = GPF_<sample>_setup_output;
			opio->pipe->transfernextstreamblock
				= GPF_<sample>_transfernextstreamblock_output;
		}	/* if */
	}	/* if */

	*dlret = (GPF_DL_OPIO);
	return rc;
}	/* GPFopen */


static int GPFclose(struct gpf_pipeline_item_t *pipe,
		    struct gpf_dlhandle *dlh)
{
	GPFDPRINT_LIBS("GPFclose(%p, %p) called for <sample> sublib\n",
			pipe, dlh);

	free(LIBGPF_PIPE_PRIVATE(pipe));
	LIBGPF_PIPE_PRIVATE(pipe) = NULL;

	return GGI_OK;
}	/* GPFclose */


int GPFdl_<sample>(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GPFopen;
		return GGI_OK;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return GGI_OK;
	case GGIFUNC_close:
		*funcptr = GPFclose;
		return GGI_OK;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GPFdl_<sample> */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
