/*
 ******************************************************************************

 LIBGPF: <sample> io pipe functions

 Copyright (C) 2002 <Author>	[<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"


ssize_t GPF_<sample>_transfernextstreamblock(gpf_handle_t handle,
				struct gpf_pipeline_item_t *pipe,
				struct timeval *transfered_timestamps)
{
        size_t transfer_size;
        size_t frame_size;
	struct gpf_pipeline_t *pipeline;
	struct <sample>gpf_priv *priv;
	size_t data_size;
	size_t writesize;
	void *buf_tmp;
	ssize_t rc;


	pipeline = handle->pipeline;

	GPFDPRINT_PIPE("%s:%s:%i: called\n", DEBUG_INFO);
	priv = <sample>_PRIV(pipe);


	LIB_ASSERT(pipe->prev != NULL);

	/* convert timeval to bytes to transfer */
	frame_size = pipe->width * pipe->height * ByPP(priv->pf_input.size);
	transfer_size = _gpf_gettransfersize(frame_size, transfered_timestamps);

        GET_PIPE_TRANSFERSIZE;
        LIMIT_TRANSFERSIZE;

	pipe->width = pipe->prev->width;
	pipe->height = pipe->prev->height;


	/* the amount of memory, that we have to transfer */
	data_size = PIPE_READBUFSIZE(pipe);
	LIB_ASSERT(data_size > 0);

	/* The size to make the conversion possible */
	REALLOC_BUFCONVSIZE(sizeof(ggi_color));

	writesize = pipe->width * pipe->height * <bytes_per_pixel>;

	LIB_ASSERT(PIPE_READBUFSIZE(pipe) >= priv->input_data_size);

	if ((ByPP(priv->pf_input.size) == ByPP(priv->pf_output.size))
	  || (ByPP(priv->pf_input.size) == sizeof(ggi_color)))
	{
		write_size = transfer_size;
	} else {
		write_size = transfer_size * ByPP(priv->pf_output.size)
					/ ByPP(priv->pf_input.size);
	}	/* if */

	rc = _gpf_realloc_writebuf(pipe, write_size);
	if (rc != GGI_OK) {
		goto err0;
	}	/* if */

	GPFDPRINT_TRANSFER("pipe-rgba: input/output buf-size (%i, %i), "
			"priv->io_data_size (%i, %i), transfer_size (%i)\n",
			PIPE_READBUFSIZE(pipe),PIPE_WRITEBUFSIZE(pipe),
			priv->input_data_size, priv->output_data_size,
			transfer_size);


	/* Change this to your own declarations in <sample>_gpf.h */
	rc = priv->doconversion(pipeline, pipe,	writesize);

	if (rc < 0) {
		GPFDPRINT("%s:%s:%i: error after conversion - rc: %i\n",
			DEBUG_INFO, rc);
		goto err1;
	}	/* if */

	LIB_ASSERT(pipe->writebytes == rc);
	if (rc > 0) {
		/* Proceed to next pipe */
		handle->pipe_index = handle->pipe_index->next;
	}	/* if */
	if (rc == 0) {
		/* Get more data from input */
		handle->pipe_index = handle->pipe_index->prev;
	}	/* if */

	return rc;

err1:
	_gpf_free_writebuf(pipe);
err0:
	free(pipe->buf_conv);
	pipe->buf_conv = NULL;
	pipe->buf_conv_size = 0;
	return rc;
}	/* GPF_<sample>_transfernextstreamnextblock */



int GPF_<sample>_getformat(struct gpf_pipeline_item_t *pipe,
			struct gpf_pipeline_item_t *from_pipe,
			int chain)
{
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(pipe);


	/* In the pipe.c file, you set up the format descriptions, this
	 * pipe can handle.
	 * Which case you should use depends if/where you use the
	 * GPF_PIPE_DF_ALLVARIANTS flag.
	 */


	/* Case 1: 
	 * 
	 * Use this, when you use the flag for _both_ input and output.
	 * 
	 * If you use the flag for input _or_ output then remove the
	 * unused part. When you only use the flag for input, then you have
	 * to remove the output part and vice versa.
	 */

	switch (chain) {
	case INFOLIST_INPUT:
		GPFDPRINT_PIPE("%s:%s:%i: get the format description for the output\n",
				DEBUG_INFO);

		LIB_ASSERT(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_INPUT) == NULL);
		LIB_ASSERT(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_OUTPUT) != NULL);

		memcpy(&priv->pf_output,
			&(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_OUTPUT)->pf),
			sizeof(struct gpf_pixelformat_t));

		LIB_ASSERT(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_OUTPUT)->memory_usage > 0);
		priv->output_data_size =
			PIPELINEITEM_STRMARK(from_pipe, INFOLIST_OUTPUT)->memory_usage;
		return GGI_OK;

	case INFOLIST_OUTPUT:
		GPFDPRINT_PIPE("%s:%s:%i: get the format description for the input\n",
				DEBUG_INFO);

		LIB_ASSERT(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_INPUT) != NULL);
		LIB_ASSERT(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_OUTPUT) == NULL);

		memcpy(&priv->pf_input,
			&(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_INPUT)->pf),
			sizeof(struct gpf_pixelformat_t));

		LIB_ASSERT(PIPELINEITEM_STRMARK(from_pipe, INFOLIST_INPUT)->memory_usage > 0);
		priv->input_data_size =
			PIPELINEITEM_STRMARK(from_pipe, INFOLIST_INPUT)->memory_usage;
		return GGI_OK;

	}	/* switch */

	return GGI_ENODEVICE;



	/* Case 2:
	 *
	 * Do nothing here, if you don't use the flag at all and
	 * return success (GGI_OK).
	 */

	return GGI_OK;
}	/* GPF_<sample>_getformat */

