/*
 ******************************************************************************

 LIBGPF: <sample> io pipe header

 Copyright (C) 2002 <Author>	[<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_debug.h>

#include <string.h>


/*
 *      "exported" Function prototypes
 */

GPFpipe_setup			GPF_<sample>_setup;
GPFpipe_getformat		GPF_<sample>_getformat;
GPFpipe_getinfolist		GPF_<sample>_getinfolist;
GPFpipe_TransferNextStreamBlock	GPF_<sample>_transfernextstreamblock;


/*
 *	internal function prototypes
 */


struct <sample>gpf_priv;


/* Put in your pipe specific conversion stuff here
 * The stuff below is only example
 * Change it to your own needs
 */



typedef ssize_t (DoConversion)(struct gpf_pipeline_t *pipeline,
				struct gpf_pipeline_item_t *pipe,
				size_t buf_size);

typedef int (GPF_map)(struct <sample>gpf_priv *<sample>, char *buf_map,
			size_t input_size, size_t output_size);			
typedef int (GPF_unmappixel)(struct <sample>gpf_priv *<sample>, char *buf_unmap,
			size_t input_size, size_t output_size);



/* Structure holding private data.
 */
struct rgbagpf_priv {
	size_t input_data_size;
	size_t output_data_size;

	struct gpf_pixelformat_t pf_input;
	struct gpf_pixelformat_t pf_output;

	GPF_map		*domap;
	GPF_unmappixel	*dounmap;
	DoConversion	*doconversion;

	/* Put in your pipe specific stuff */
};


#define <sample>_PRIV(pipe)		\
		((struct <sample>gpf_priv *)(LIBGPF_PIPE_PRIVATE(pipe)))
