/* $Id: init.c,v 1.1.1.1 2001/05/01 18:45:15 cegger Exp $
******************************************************************************

   Bse extension initialization.

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]
		 2001 Christoph Egger	[Christoph_Egger@t-online.de]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include <ggi/internal/bse.h>


#include <ggi/ovl.h>
#include <ggi/blt.h>


/* Static variables 
 */

static int _ggibseLibIsUp = 0;

struct resourcelist_t *reslist = NULL;



int ggiBseInit(void)
{
	int err = 0;

	_ggibseLibIsUp++;
	if (_ggibseLibIsUp > 1) {
#if 0
		if (_ggibseLibIsUp >= BSE_MAX_USAGE) {
			/* Max initializes reached! */
			_ggibseLibIsUp--;
			return -1;
		}	/* if */
#endif
		return 0;	/* Initialize only at first call. */
	}	/* if */


	if ((err = ggiOvlInit()) != 0) {
		fprintf(stderr,"LibBSE: couldn't Initilize LibOVL.\n");
		_ggibseLibIsUp--;
		return err;
	}	/* if */

	if ((err = ggiBltInit()) != 0) {
		fprintf(stderr,"LibBSE: couldn't Initilize LibBLT.\n");
		_ggibseLibIsUp--;
		return err;
	}	/* if */


	return 0;
}	/* ggiBseInit */


int ggiBseExit(void)
{
	int rc = 0;
    
	if (!_ggibseLibIsUp) {
		return -1;
	}	/* if */

	if (_ggibseLibIsUp > 1) {
		/* Exit only at last call */
		_ggibseLibIsUp--;
		return 0;
	}	/* if */
	

#warning  TODO: Check the return-code here
	rc = ggiBltExit();
	rc = ggiOvlExit();


	_ggibseLibIsUp = 0;

	return rc;
}	/* ggiBseExit */


int ggiBseAttach(ggi_visual_t vis)
{
	int rc = GALLOC_OK;
	struct resourcelist_t *new_res = NULL;
	struct resourcelist_t *res_index = NULL;

	new_res = calloc(1, sizeof(struct resourcelist_t));
	if (!new_res) {
		printf("libBSE:ggiOvlAttach() failed: %i!\n", __LINE__);
		rc = GGI_ENOMEM;
		goto err0;
	}	/* if */

	rc = ggiOvlAttach(vis, NULL);
	if (rc < 0) {
		printf("libBSE:ggiOvlAttach() failed: %i!\n", __LINE__);
		goto err1;
	}	/* if */

	rc = ggiBltAttach(vis, NULL);
	if (rc < 0) {
		printf("libBSE:ggiBltAttach() failed: %i!\n", __LINE__);
		goto err2;
	}	/* if */

	new_res->vis = vis;
	new_res->first = NULL;

	printf("before add_new_resource: reslist: %p, res_index: %p, new_res: %p\n",
		reslist, res_index, new_res);

	ADD_NEW_RESOURCE(res_index, new_res);

	if ((reslist != new_res))
		fprintf(stderr, "assertion \"reslist == new_res\" failed.\n");

	printf("after add_new_resource: reslist: %p, res_index: %p, new_res: %p\n",
		reslist, res_index, new_res);


	{

	struct resourcelist_t *find_res = NULL;
	FIND_RESOURCE(vis, find_res);
	if ((find_res == NULL))
		fprintf(stderr, "assertion \"find_res != NULL\" failed.\n");
	if ((find_res != new_res))
		fprintf(stderr, "assertion \"find_res == new_res\" failed.\n");

	}

	printf("libBSE: ggiBseAttach() returns successfully %i\n", rc);
	return rc;


err2:
	ggiOvlDetach(vis);	
err1:
	free(new_res);
err0:
	printf("libBSE: ggiBseAttach() failed! %i\n", rc);
	return rc;
}	/* ggiBseAttach */


int ggiBseDetach(ggi_visual_t vis)
{
	int rc = 0;
	struct resourcelist_t *cur_res = NULL;

	ggiBse_t next;
	ggiBse_t remains;


	{
	int rc1, rc2;
	rc1 = ggiBltDetach(vis);
	rc2 = ggiOvlDetach(vis);

	if (rc1 != rc2) fprintf(stderr, "%s:%s:%i: assertion \"rc1 == rc2\" failed.\n", DEBUG_INFO);
	rc = rc2;
	}
	if (rc != 0) return rc;


	FIND_RESOURCE(vis, cur_res);
	if (cur_res == NULL) {
		fprintf(stderr, "Sorry! But this visual was never attached before!\n");
		return -1;
	}	/* if */

	remains = cur_res->first;
	while (remains != NULL) {
		next = remains->next;
		ggiBseDestroy(remains);
		remains = next;
	}	/* while */


	DESTROY_RESOURCE(cur_res);


	return rc;
}	/* ggiBseDetach */
