/*
******************************************************************************

   Demo of the GPF library.

   Authors:	2002 Christoph Egger	[Christoph_Egger@t-online.de]
  
   This code is placed in the public domain and may be used freely for any
   purpose.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/ggi.h>
#include <ggi/gpf.h>


#if 0
#define USE_PARAMS
#endif

static int do_conv(const char *filename, const char *filename_output)
{
	int rc;
	gpf_handle_t handle;
	struct gpf_properties_t props;


	handle = gpfOpen("ppm", filename,
			"ppm", filename_output);

	if (!handle) gpfPanic("Couldn't create handle\n");

	rc = gpfPipelineSetup(handle);
	if (rc < 0) gpfPanic("Couldn't setup pipeline\n");

	gpfClearProperties(&props);
	gpfSetFlags(&props, GPF_TIMESTAMP_FIRST);
	gpfSetProperties(handle, &props);


	printf("start data-transfer\n");
	gpfStartStream(handle);

	while (!gpfIsStopped(handle)) {
		gpfTransferNextStreamBlock(handle, NULL);
	}	/* while */

	printf("finished data-transfer\n");

	gpfClose(handle);

	return 0;
}	/* do_conv */



int main(int argc, char **argv)
{
	char *filename;
	char *filename_output;

#ifdef USE_PARAMS
	if (argc < 3) {
		printf("Usage: %s file:/<path>/<filename>.ppm "
			"file:/<path>/<newfilename>.ppm",
			argv[0]);
		return -1;
	}	/* if */
	filename = argv[1];
	filename_output = argv[2];
#else
	filename = "file:./ggi_logo.ppm";
	filename_output = "file:./test.ppm";
#endif

	printf("Load %s, convert and store it as %s\n",
		filename, filename_output);


	/* Initialize libGPF */
	if (gpfInit() != 0) {
		ggiPanic("Unable to initialize LibGPF\n");
	}	/* if */

	/* Try the API functions */
	do_conv(filename, filename_output);

	/* Deinitialize libGPF */
	gpfExit();

	return 0;
}	/* main */
