/*
 ******************************************************************************

 LIBGPF: library internals

 Copyright (C) 2001 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#ifndef _GPF_INT_PIPE_H
#define _GPF_INT_PIPE_H


#include <ggi/internal/gpf.h>



struct gpf_pipeline_t;
struct gpf_pipeline_item_t;

struct gpf_infolist_t;


struct gpf_infolist_link_t {
	struct gpf_infolist_link_t *next;
	struct gpf_infolist_t *linkto;
};


struct gpf_infolist_t {
	struct gpf_infolist_t *next;

	/* only input connect to output
	 * if this is an output, then it's always NULL
	 */
	struct gpf_infolist_link_t *linkto_head;

	uint32 nr;	/* counting number */

	/* The memory required to hold the data */
	size_t memory_usage;

	/* The runtime needed for this algorithm */
	double runtime;

	/* The pixel format */
	struct gpf_pixelformat_t pf;
};



/* infolist
 */
#define for_each_infolist_c(head, condition, index)	\
		for (index = head; condition; index = index->next)

#define for_each_infolist(head, index)	\
		for_each_infolist_c(head, index != NULL, index)

#define _gpfInfoListGotoLastOne(head, index)	\
		if (head == NULL) {		\
			index = NULL;		\
		} else {			\
			for_each_infolist_c(head,		\
				index->next != NULL, index);	\
		}

#define for_each_infolist_input_c(head, condition, index)	\
		for_each_infolist_c(head->input_head, condition, index)

#define for_each_infolist_input(head, index)		\
		for_each_infolist_input_c(head, index != NULL, index)

#define for_each_infolist_output_c(head, condition, index)	\
		for_each_infolist_c(head->output_head, condition, index)

#define for_each_infolist_output(head, index)		\
		for_each_infolist_output_c(head, index != NULL, index)


struct gpf_infolist_t *_gpfInfoListCreate(void);
int _gpfInfoListDestroy(struct gpf_infolist_t **head);

int _gpfInfoListAppend(struct gpf_infolist_t *head,
			struct gpf_infolist_t *item);

int _gpfInfoListConnect(struct gpf_infolist_t *item1,
			struct gpf_infolist_t *item2);

int _gpfInfoListUnconnect(struct gpf_infolist_t *item);

struct gpf_infolist_t *_gpfInfoListClone(struct gpf_infolist_t *inflist);




/* pipeline items
 */
#define for_each_pipeline_item_c(head, condition, index)	\
		for (index = head->item_head; condition; index = index->next)

#define for_each_pipeline_item(head, index)		\
		for_each_pipeline_item_c(head, index != NULL, index)

#define _gpfPipelineItemGotoLastOne(head, index)	\
		if (head->item_head == NULL) {		\
			index = NULL;			\
		} else {				\
			for_each_pipeline_item_c(head,	\
					index->next != NULL, index);	\
		}

struct gpf_pipeline_item_t *_gpfPipelineItemCreate(void);

int _gpfPipelineItemDestroy(struct gpf_pipeline_item_t **pipeitem);

int _gpfPipelineItemIsTarget(struct gpf_pipeline_item_t *pipe);

int _gpfPipelineItemAppend(struct gpf_pipeline_t *pipeline,
                        struct gpf_pipeline_item_t *pipeitem);

int _gpfPipelineItemInsert(struct gpf_pipeline_item_t *item,
                        struct gpf_pipeline_item_t *pipe);

int _gpfPipelineItemRemove(struct gpf_pipeline_item_t *item,
			struct gpf_pipeline_item_t *pipe);

int _gpfPipelineItemIsEqual(struct gpf_pipeline_item_t *pipe1,
			struct gpf_pipeline_item_t *pipe2);

struct gpf_pipeline_item_t *_gpfPipelineItemClone(
			struct gpf_pipeline_item_t *pipe);







/* pipeline
 */
#define for_each_pipeline_c(head, condition, index)		\
		for (index = head; condition; index = index->next)

#define for_each_pipeline(head, index)		\
		for_each_pipeline_c(head, index != NULL, index)

#define _gpfPipelineGotoLastOne(head, index)	\
		if (head == NULL) {		\
			index = NULL;		\
		} else {			\
			for_each_pipeline_c(head,		\
				index->next != NULL, index);	\
		}

int _gpfPipelineShutdown(gpf_handle_t handle);

struct gpf_pipeline_t *_gpfPipelineCreate(void);
int _gpfPipelineDestroy(struct gpf_pipeline_t **pipeline_head,
			struct gpf_pipeline_t *execpt_pipeline);


struct gpf_pipeline_t *_gpfPipelineFind(
				struct gpf_handle_pipeline_t *hnd_pipeline,
				struct gpf_pipeline_t *head);
struct gpf_pipeline_t *_gpfPipelineFindOptimal(gpf_handle_t handle,
				struct gpf_handle_pipeline_t *hnd_pipeline);

int _gpfPipelineIsEqual(struct gpf_pipeline_t *pipeline1,
			struct gpf_pipeline_t *pipeline2);

int _gpfPipelineIsUnique(struct gpf_pipeline_t *pipeline_head,
			struct gpf_pipeline_t *pipeline);

struct gpf_pipeline_t *_gpfPipelineSelect(struct gpf_pipeline_t *pipeline_head,
					struct gpf_properties_t *props);

struct gpf_pipeline_item_t *_gpfPipelineFindSuitableItem(
					struct gpf_pipeline_t *pipeline,
					struct gpf_pipeline_item_t *prev,
					struct gpf_pipeline_item_t *next);

int  _gpfPipelineRemoveItem(struct gpf_pipeline_t *pipeline,
			struct gpf_pipeline_item_t *pipe);

struct gpf_pipeline_t *_gpfPipelineClone(struct gpf_pipeline_t *pipeline);




#endif	/* _GPF_INT_PIPE_H */
