/*
 ******************************************************************************

 LIBGPF: null io target initialisation

 Copyright (C) 2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "null_gpf.h"
#include <ggi/internal/gpf_internal.h>


static int GPFopen(struct gpf_handle_opio_t *opio,
		   struct gpf_pipeline_item_t *pipe,
		   struct gpf_dlhandle *dlh, const char *args,
		   va_list ap, uint32 *dlret)
{
	struct nullgpf_priv *priv;

	GPFDPRINT_LIBS("GPFopen(%p, %p, %p, %s, %p, %p) called for null sublib\n",
		opio, pipe, dlh, args ? args : "(NULL)", ap, dlret);

	LIBGPF_IO_PRIVATE(opio) = malloc(sizeof(struct nullgpf_priv));
	if (LIBGPF_IO_PRIVATE(opio) == NULL) return GGI_ENOMEM;


	priv = NULL_PRIV(opio);

	/* Initialize the priv structure with zeros, because
	 * uninitialized values may cause crashes in threaded applications
	 */
	memset(priv, 0, sizeof(struct nullgpf_priv));



	opio->open = GPF_NULL_open;
	opio->close = GPF_NULL_close;

	opio->timestamp = GPF_NULL_timestamp;

	opio->read = GPF_NULL_read;
	opio->write = GPF_NULL_write;
	opio->doio = GPF_NULL_doio;

	opio->pipe->getformat = GPF_NULL_getformat;
	opio->pipe_getinfolist = GPF_NULL_pipe_getinfolist;

	if (opio->type & GPF_DLTYPE_INPUT) {
		opio->pipe->setup = GPF_NULL_setup_input;
		opio->pipe->transfernextstreamblock
			= GPF_NULL_transfernextstreamblock_input;
	}	/* if */

	if (opio->type & GPF_DLTYPE_OUTPUT) {
		opio->pipe->setup = GPF_NULL_setup_output;
		opio->pipe->transfernextstreamblock
			= GPF_NULL_transfernextstreamblock_output;
	}	/* if */

	*dlret = (GPF_DL_OPIO);
	return GGI_OK;
}	/* GPFopen */


static int GPFclose(struct gpf_pipeline_item_t *pipe,
		    struct gpf_dlhandle *dlh)
{
	GPFDPRINT_LIBS("GPFclose(%p, %p) called for null sublib\n",
			pipe, dlh);

	free(LIBGPF_PIPE_PRIVATE(pipe));
	LIBGPF_PIPE_PRIVATE(pipe) = NULL;

	return GGI_OK;
}	/* GPFclose */


int GPFdl_null(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GPFopen;
		return GGI_OK;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return GGI_OK;
	case GGIFUNC_close:
		*funcptr = GPFclose;
		return GGI_OK;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GPFdl_null */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
