/*
 ******************************************************************************

 LIBGPF: null io target header

 Copyright (C) 2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_debug.h>
#include <ggi/internal/gpf_helpers.h>

#include <string.h>


/*
 *      "exported" Function prototypes
 */

GPFio_open			GPF_NULL_open;
GPFio_close			GPF_NULL_close;

GPFio_timestamp			GPF_NULL_timestamp;

GPFio_read			GPF_NULL_read;
GPFio_write			GPF_NULL_write;
GPFio_doio			GPF_NULL_doio;

GPFpipe_setup			GPF_NULL_setup_input;
GPFpipe_setup			GPF_NULL_setup_output;
GPFpipe_TransferNextStreamBlock	GPF_NULL_transfernextstreamblock_input;
GPFpipe_TransferNextStreamBlock	GPF_NULL_transfernextstreamblock_output;
GPFpipe_getformat		GPF_NULL_getformat;
GPFio_pipe_getinfolist		GPF_NULL_pipe_getinfolist;


struct nullgpf_priv;



/* Structure holding private data.
 */
struct nullgpf_priv {
	uint32 nr;

	struct gpf_pixelformat_t pf;

	/* Put in your target specific stuff */
        size_t input_data_size;
        size_t output_data_size;

	off_t offset;
};

#define NULL_PRIV(io)		\
		((struct nullgpf_priv *)(LIBGPF_IO_PRIVATE(io)))
