/* $Id: bse.h,v 1.1.1.1 2001/05/01 18:46:59 cegger Exp $
******************************************************************************

   LibGGI BSE API header file

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 2001 Christoph Egger	[Christoph_Egger@t-online.de]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_BSE_H
#define _GGI_BSE_H

#include <ggi/ggi.h>

#include <ggi/galloc.h>
#include <ggi/ovl.h>
#include <ggi/blt.h>


#ifdef HAVE_STRUCT_BSE
typedef struct ggiBse *ggiBse_t;
#else
struct ggiBse { };

typedef struct ggiBse *ggiBse_t;
#endif

__BEGIN_DECLS


int ggiBseInit(void);
int ggiBseExit(void);

int ggiBseAttach(ggi_visual_t vis);
int ggiBseDetach(ggi_visual_t vis);





/* Creating a Sprite.
 */
ggiBse_t ggiBseCreateSprite(ggi_visual_t vis, int width, int height,
			    ggi_graphtype gt);

/* Creating a Bob.
 */
ggiBse_t ggiBseCreateBob(ggi_visual_t vis, int width, int height,
			 ggi_graphtype gt);

/* Destroy Bob/Sprite
 */
int ggiBseDestroy(ggiBse_t bse);


/* BOB converting function
 * Allows you to use the libBlt API for BOBs.
 * Note, that the bse-structure is _not_ destroyed.
 */
ggiBlt_t ggiBob2Blt(ggiBse_t bse);




/* Populate the sprite
 */
int ggiBseSetImage(ggiBse_t bse, ggi_visual_t vis, int x,int y,
		   unsigned char *alpha);

/* Move the sprite around.
 */
int ggiBseMove(ggiBse_t bse,int x,int y);


/* Hiding and showing
 */
int ggiBseHide(ggiBse_t bse);
int ggiBseShow(ggiBse_t bse);


int ggiBseIsSpriteEmulated(ggiBse_t bse);


/* Hiding and showing of _emulated_ Sprites.
 * Has no effect to Bob's and real Sprites.
 */
int ggiBseHideIfEmulated(ggiBse_t bse);
int ggiBseShowIfEmulated(ggiBse_t bse);



/* HELPERS */


/* Some helpers for generating alpha arrays on the fly. They malloc the 
 * resulting array, so be sure to free() it again. The bob argument is used
 * to determine the size.
 */
unsigned char *ggiBseMakeAlphaFromPixelkey(ggiBse_t bse,
			ggi_visual_t vis,int x,int y,ggi_pixel pix);
unsigned char *ggiBseMakeAlphaFromColorkey(ggiBse_t bse,
			ggi_visual_t vis,int x,int y,ggi_color *col);


/* Some helpers for _CHANGING_ alpha arrays on the fly. As above, but they
 * operate on an existing alpha array. No malloc is performed.
 */

/* Arbitrary transforms :
 */
unsigned char *ggiBseChangeAlphaByFunction(ggiBse_t bse, 
		unsigned char *alpha,
		unsigned char (*func)(unsigned char in,void *parms),
		void *parms);

/* "harden" an alpha-channel. Especially useful for speeding things up.
 * A yes/no type alphachannel can be handled much more efficiently.
 */
unsigned char *ggiBseChangeAlphaTreshold(ggiBse_t bse, 
					unsigned char *alpha,
					unsigned char treshold);

/* Useful if you need the "negative" of an alpha channel.
 */
unsigned char *ggiBseChangeAlphaInvert(ggiBse_t bob, unsigned char *alpha);


__END_DECLS

#endif /* _GGI_BSE_H */
