/*
 * lazy.c - Author 1999 Andreas Beck   becka@ggi-project.org
 *
 * This is an example action library for the very lazy. It implements the
 * probably most wanted policy for state-oriented programs.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <ggi/gic.h>
#include <ggi/gicaction_lazy.h>

static void gicActionLazyRecalc(gicActionLazyData *data)
{
	int x;
	data->current=GIC_STATE_MIN;
	for(x=0;x<MAXRECOGNIZERS;x++) {
		if (data->array[x]>data->current)
			data->current=data->array[x];
	}
}

/* 
 * The LazyAction. Bind this to all recognizers you want to use it for.
 */
void gicActionLazyAction(gic_handle_t hand, gic_actionlist *action,gic_feature *feature,gic_state newstate,gic_flag flag,int recnum)
{
	gicActionLazyData *data=action->privdata;

	if ( flag & GIC_FLAG_PULSE )	{

		if (newstate>data->pulse) 
			data->pulse=newstate;
		if (recnum>=0&&recnum<MAXRECOGNIZERS)
			data->array[recnum]=GIC_STATE_MIN;
		return;
	}

        if ( flag & GIC_FLAG_MUSTKNOWMASK ) return;	/* Must know, but don't know. */
        
	if (recnum>=0&&recnum<MAXRECOGNIZERS) {

		if (data->array[recnum]==data->current && newstate<data->current) {
			data->array[recnum]=newstate;
			gicActionLazyRecalc(data);
		}
		data->array[recnum]=newstate;
		if (newstate>data->current)
			data->current=newstate;
	}
	return;
}

gic_state gicActionLazyGetstate(gicActionLazyData *data)
{
	gic_state hlp;

	if ((hlp=data->pulse)>data->current) {
		data->pulse=GIC_STATE_MIN;	/* Send pulses only once. */
		return hlp;
	}
	data->pulse=GIC_STATE_MIN;	/* Send pulses only once. */
	return data->current;
}

void gicActionLazyReset(gicActionLazyData *data)
{
	int x;
	data->current=data->pulse=GIC_STATE_MIN;
	for(x=0;x<MAXRECOGNIZERS;x++)
		data->array[x]=GIC_STATE_MIN;
}
