/*
 ******************************************************************************

 LIBGPF: dynamic loading

 Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */


#ifndef _GPF_INTERNAL_DL_H
#define _GPF_INTERNAL_DL_H


#include <ggi/gg.h>


/* Versioning
 */

#define GPF_VERSION_DLL		1

/* Create a OP version number from the library and structure revisions
 * for (ABI compatability)
 */
#define GPF_VERSION_MK(st_rev)          ((GPF_VERSION_DLL<<16)|st_rev)
#define GPF_LIBRARY_REVISION(vers)      (((uint32)vers)>>16)
#define GPF_STRUCTURE_REVISION(vers)    ((vers) & 0xFFFF)




/* Sublib handling
 */

extern void *_gpfConfigHandle;


/* Sublib functions */
struct gpf_dlhandle;

#define GPFFUNC_open    1
#define GPFFUNC_exit    2
#define GPFFUNC_close   3

typedef int (gpffunc_dlentry)(int func, void **funcptr);

typedef int (gpffunc_open)(struct gpf_handle_opio_t *opio,
			struct gpf_pipeline_item_t *pipe,
			struct gpf_dlhandle *dlh,
			const char *arg, va_list ap, uint32 *dlret);
typedef int (gpffunc_exit)(struct gpf_pipeline_item_t *pipe,
			struct gpf_dlhandle *dlh);
typedef int (gpffunc_close)(struct gpf_pipeline_item_t *pipe,
			struct gpf_dlhandle *dlh);


/*
******************************************************************************
 Structures to manage dynamicly loaded modules
******************************************************************************
*/


#define GPF_DL_ERROR		0x80000000
#define GPF_DL_OPPROTO		0x00000001
#define GPF_DL_OPPIPE		0x00000002
#define GPF_DL_OPIO		0x00000004

#ifndef GPF_DLTYPE_INPUT
#define GPF_DLTYPE_INPUT	0x01
#endif
#ifndef GPF_DLTYPE_OUTPUT
#define GPF_DLTYPE_OUTPUT	0x02
#endif

#define GPF_DLTYPE_GLOBAL	0x04	/* Resolve library's exported symbols */
#define GPF_DLTYPE_LOCAL	0x00


typedef struct gpf_dlhandle {
	gg_module *handle;
	char	*name;
	int	usecnt;

	struct gpf_pipeline_item_t *pipe;
	gpffunc_dlentry	*entry;
	gpffunc_open	*open;
	gpffunc_exit	*exit;
	gpffunc_close	*close;
} gpf_dlhandle;


typedef struct gpf_dlhandle_l {
	struct gpf_dlhandle	*handle;
	struct gpf_dlhandle_l	*next;
} gpf_dlhandle_l;


struct gpf_op_head {
	unsigned int	version;
	gpf_dlhandle_l	*dlhandle;

	void		*dummy;	/* For future expansion */
};


int _gpfOpenDL(struct gpf_handle_opio_t *opio,
		struct gpf_pipeline_item_t *pipe,
		const char *name, const char *args,
		va_list ap, int type);
int _gpfCloseDL(struct gpf_pipeline_item_t *pipe);


#endif	/* _GPF_INTERNAL_DL_H */

