/*
 ******************************************************************************

 LIBGPF: library internals

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#ifndef _GPF_INTERNAL_INTERNAL_H
#define _GPF_INTERNAL_INTERNAL_H


#include <ggi/internal/gpf.h>
#include <stdarg.h>


/* Internal parsing functions
 */

int _gpfParseArgs(const char *args, va_list *argptr, ...);

int _gpfParseProtocol(const char *argf, va_list ap,
		char *protocol, char *proto_argf, va_list *proto_ap);

/* Returns the pointer pointing to the next argument of the last
 * one in fmt.
 */
int _gpfGetLastArg(const char *fmt, va_list *ap);




/* Internal open/close functions
 */


int _gpfOpenTarget(gpf_handle_t hnd, int *idx, const char *target,
		const char *argf, va_list ap, int type);

int _gpfCloseTarget(gpf_handle_t hnd, int idx, int type);


int _gpfOpenProtocol(struct gpf_handle_opio_t *opio,
		const char *protocol, const char *argf, va_list ap);

int _gpfCloseProtocol(struct gpf_handle_opio_t *opio);


struct gpf_pipeline_item_t *_gpfOpenPipe(const char *pipe_string);

int _gpfClosePipe(struct gpf_pipeline_item_t **pipe);



/* Internal pipeline binding functions
 */

int _gpfHandlePipelineCreate(gpf_handle_t hnd);

int _gpfHandlePipelineBind(gpf_handle_t hnd, int src_idx, int dst_idx,
			int pipeline_idx);



/* handle creation/destruction
 */

gpf_handle_t _gpfNewHandle(void);
int _gpfDestroyHandle(gpf_handle_t hnd);


/* Loops
 */

#define for_each_handle_pipeline(handle, idx)	\
	for (idx = 0; idx < handle->num_pipelines; idx++)

#define for_each_handle_input(handle, idx)	\
	for (idx = 0; idx < handle->num_inputs; idx++)

#define for_each_handle_output(handle, idx)	\
	for (idx = 0; idx < handle->num_outputs; idx++)


#endif	/* _GPF_INTERNAL_INTERNAL_H */
