/*
 ******************************************************************************

 LIBGPF: null io target functions (read/write)

 Copyright (C) 2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "null_gpf.h"


static int GPF_proto_open(struct gpf_handle_opio_t *opio,
			int flags)
{
	int rc = GGI_OK;
	struct nullgpf_priv *priv;

	GPFDPRINT_PROTO("%s:%s:%i: called\n", DEBUG_INFO);
	priv = NULL_PRIV(opio);

	priv->offset = 0;

	return rc;
}	/* GPF_proto_open */


static int GPF_proto_close(struct gpf_handle_opio_t *opio)
{
	struct nullgpf_priv *priv;

	GPFDPRINT_PROTO("%s:%s:%i: called\n", DEBUG_INFO);
	priv = NULL_PRIV(opio);

	return GGI_OK;
}	/* GPF_proto_close */



static ssize_t GPF_proto_read(struct gpf_handle_opio_t *opio,
			void *buf, size_t size)
{
	int rc = GGI_OK;
	struct nullgpf_priv *priv;

	GPFDPRINT_PROTO("%s:%s:%i: called\n", DEBUG_INFO);
	priv = NULL_PRIV(opio);

	memset(buf, 0, size);

	return rc;
}	/* GPF_proto_read */




static ssize_t GPF_proto_write(struct gpf_handle_opio_t *opio,
			void *buf, size_t size)
{
	int rc = GGI_OK;
	struct nullgpf_priv *priv;

	GPFDPRINT_PROTO("%s:%s:%i: called\n", DEBUG_INFO);
	priv = NULL_PRIV(opio);

	return rc;
}	/* GPF_proto_write */



static off_t GPF_proto_lseek(struct gpf_handle_opio_t *opio,
			off_t offset, int whence)
{
	off_t rc = 0;
	struct nullgpf_priv *priv;

	GPFDPRINT_PROTO("%s:%s:%i: called\n", DEBUG_INFO);
	priv = NULL_PRIV(opio);

	LIBGPF_IO_UNMARK_EOS(opio);

	switch (opio->type) {
	case GPF_DLTYPE_INPUT:
		switch (whence) {
		case SEEK_SET:

			rc = priv->offset = offset;
			break;

		case SEEK_CUR:

			priv->offset += offset;
			rc = priv->offset;
			break;

		case SEEK_END:

			priv->offset = (unsigned)~0;
			rc = -1;
			break;
		}	/* switch */
		break;

	case GPF_DLTYPE_OUTPUT:
		switch (whence) {
		case SEEK_SET:
			rc = priv->offset = offset;
			break;

		case SEEK_CUR:
			priv->offset += offset;
			rc = priv->offset;
			break;

		case SEEK_END:

			priv->offset = (unsigned)~0;
			rc = -1;
			break;
		}	/* switch */
		break;

	default:
		rc = -1;
		break;
	}	/* switch */

	return rc;
}	/* GPF_proto_lseek */


static int GPF_proto_flush(struct gpf_handle_opio_t *opio)
{
	int rc = GGI_OK;
	struct nullgpf_priv *priv;

	GPFDPRINT_PROTO("%s:%s:%i: called\n", DEBUG_INFO);
	priv = NULL_PRIV(opio);

	return rc;
}	/* GPF_proto_flush */



static int GPF_proto_eos(struct gpf_handle_opio_t *opio)
{
	GPFDPRINT_TARGET("%s:%s:%i: is_eos (%i)\n",
			DEBUG_INFO, opio->opproto->is_eos);

	return LIBGPF_IO_IS_EOS(opio);
}	/* GPF_proto_eos */




int GPF_NULL_doio(struct gpf_handle_opio_t *opio,
		const char *args, va_list ap)
{
	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);

	opio->opproto->open = GPF_proto_open;
	opio->opproto->close = GPF_proto_close;

	opio->opproto->read = GPF_proto_read;
	opio->opproto->write = GPF_proto_write;

	opio->opproto->lseek = GPF_proto_lseek;
	opio->opproto->flush = GPF_proto_flush;
	opio->opproto->eos = GPF_proto_eos;

	return GGI_OK;
}	/* GPF_NULL_doio */
