/*
 ******************************************************************************

 LIBGPF: <sample> io pipeline communication functions

 Copyright (C) 2002 <Author>	[<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"


static int _<sample>_getinfonr(int chain)
{
	switch (chain) {
	case INFOLIST_INPUT:

#warning Return the total number of supported (pixel-)formats here

		/* ... when this target acts as an input */
		return 2;

	case INFOLIST_OUTPUT:

#warning Return the total number of supported (pixel-)formats here

		/* ... when this target acts as an output */
		return 2;

	}	/* switch */

	return 0;
}	/* _<sample>_getinfonr */


/* fills in the information of pixelformats it can handle
 * from the input
 */
static void _<sample>_fillinfo_input(struct gpf_handle_opio_t *opio,
			struct gpf_infolist_t *item,
			int nr)
{
	struct <sample>gpf_priv *priv;

	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);
	priv = <sample>_PRIV(opio);


	/* Initizalize everything with zero */
	memset(&item->pf, 0, sizeof(struct gpf_pixelformat_t));

	item->pf.cf = GPF_CF_<cf_flag>;
	item->pf.flags = GPF_PIPE_DF_<df_flags>;


	/* You may set up common values for all formats here
	 */


	switch (nr) {
	case 0:
		/* Format1
		 */

		item->pf.depth = ?;	/* significant bits per pixel */
		item->pf.size = ?;	/* total used bits per pixel */

#warning Set the right mask values


		item->memory_usage = PF_ByPP(item->pf.size)
				* priv->width * priv->height;

		/* Calculate the runtime here
		 * See the developers guide for more information about that
		 */
		item->runtime = item->memory_usage * 1.0;
		break;

	case 1:
		/* Format2
		 */

		item->pf.depth = ?;	/* significant bits per pixel */
		item->pf.size = ?;	/* total used bits per pixel */

#warning Set the right mask values


		item->memory_usage = PF_ByPP(item->pf.size)
				* priv->width * priv->height;

		/* Calculate the runtime here
		 * See the developers guide for more information about that
		 */
		item->runtime = item->memory_usage * log(2.0);
		break;

	default:
		fprintf(stderr, "Unknown nr: %i\n", nr);
		break;
	}	/* switch */

	return;
}	/* _<sample>_fillinfo_input */



/* fills in the information of pixelformats it can convert to
 */
static void _<sample>_fillinfo_output(struct gpf_handle_opio_t *opio,
			struct gpf_infolist_t *item,
			int nr)
{
	struct <sample>gpf_priv *priv;

	GPFDPRINT_TARGET("%s:%s:%i: called\n", DEBUG_INFO);
	priv = <sample>_PRIV(opio);


	/* Initizalize everything with zero */
	memset(&item->pf, 0, sizeof(struct gpf_pixelformat_t));

	item->pf.cf = GPF_CF_<cf_flag>;
	item->pf.flags = GPF_PIPE_DF_<df_flags>;


	/* You may set up common values for all formats here
	 */


	switch (nr) {
	case 0:
		/* Format1
		 */

		item->pf.depth = ?;	/* significant bits per pixel */
		item->pf.size = ?;	/* total used bits per pixel */

#warning Set the right mask values


		item->memory_usage = item->pf.size
				* priv->width * priv->height;

		/* Calculate the runtime here
		 * See the developers guide for more information about that
		 */
		item->runtime = item->memory_usage * 1.0;
		break;

	case 1:
		/* Format2
		 */

		item->pf.depth = ?;	/* significant bits per pixel */
		item->pf.size = ?;	/* total used bits per pixel */

#warning Set the right mask values


		item->memory_usage = item->pf.size
				* priv->width * priv->height;

		/* Calculate the runtime here
		 * See the developers guide for more information about that
		 */
		item->runtime = item->memory_usage * log(2.0);
		break;

	default:
		fprintf(stderr, "Unknown nr: %i\n", nr);
		break;
	}	/* switch */

	return;
}	/* _<sample>_fillinfo_output */




static void _<sample>_fillinfo(struct gpf_handle_opio_t *opio,
			struct gpf_infolist_t *item,
			int nr, int chain)
{
	switch (chain) {
	case INFOLIST_INPUT:
		_<sample>_fillinfo_input(opio, item, nr);
		break;

	case INFOLIST_OUTPUT:
		_<sample>_fillinfo_output(opio, item, nr);
		break;

	}	/* switch */

	return;
}	/* _<sample>_fillinfo */



static struct gpf_infolist_t *_<sample>_getInfolist(
					struct gpf_handle_opio_t *opio,
					int chain)
{
	int nr, i;
	struct gpf_infolist_t *head = NULL;
	struct gpf_infolist_t *item = NULL;


	nr = _<sample>_getinfonr(chain);
	item = _gpfInfoListCreate();
	if (!item) {
		goto err0;
	}	/* if */
	_<sample>_fillinfo(opio, item, 0, chain);
	head = item;

	for (i = 1; i < nr; i++) {
		item = _gpfInfoListCreate();
		if (!item) {
			goto err1;
		}	/* if */

		_<sample>_fillinfo(opio, item, i, chain);

		_gpfInfoListAppend(head, item);
	}	/* for */


	return head;


err1:
	_gpfInfoListDestroy(&item);
	_gpfInfoListDestroy(&head);
err0:
	return NULL;
}	/* _<sample>_getInfolist */


int GPF_<sample>_pipe_getinfolist(struct gpf_handle_opio_t *opio)
{
	int rc = GGI_OK;
	struct gpf_pipeline_item_t *pipe;

	pipe = opio->pipe;

	LIB_ASSERT(pipe != NULL);

	LIB_ASSERT(pipe->input_head == NULL);
	LIB_ASSERT(pipe->output_head == NULL);


	switch (opio->type) {
	case GPF_DLTYPE_INPUT:
		/* This target interacts as an input, so we need the
		 * information, what it offers to the next pipe...
		 */
		pipe->output_head = _<sample>_getInfolist(opio, INFOLIST_OUTPUT);
		if (!pipe->output_head) {
			rc = GGI_ENOMEM;
			goto err0;
		}	/* if */
		break;


	case GPF_DLTYPE_OUTPUT:
		/* This target interacts as an output, so we need the
		 * information, what it can handle from the previous pipe...
		 */
		pipe->input_head = _<sample>_getInfolist(opio, INFOLIST_INPUT);
		if (!pipe->input_head) {
			rc = GGI_ENOMEM;
			goto err0;
		}	/* if */
		break;

	}	/* switch */

err0:
	return rc;
}	/* GPF_<sample>_pipe_getinfolist */
