#include <stdio.h>
#include <ggi/ggi.h>
#include <ggi/ggi_ext.h>

#include <ggi3d/3d.h>

#include <ggi3d/module.h>
#include <ggi3d/interface.h>
#include <ggi3d/modules/renderworld.h>
#include <ggi3d/modules/ggivis.h>
#include <ggi3d/modules/debug.h>
#include <ggi3d/modules/globals.h>
#include <glib.h>

ggi_visual_t vis;
ggi3d_modp mod_renderworld;
ggi3d_modp mod_debug;
ggi3d_modp mod_ggivis;

void setup_all_modules(void)
{
#if 0
	mod_renderworld = ggi3d_load_module(vis, "renderworld");
	if (mod_renderworld == NULL)
	{
		ggiPanic("Error loading renderworld module\n");
	}
	
	mod_debug = ggi3d_load_module(vis, "debug");
	if (mod_debug == NULL)
	{
		ggiPanic("Error loading debugger module\n");
	}
#endif	
	mod_ggivis = ggi3d_load_module(vis, "ggivis");
}

void test_renderworld(void)
{
	renderworld_input_t the_world;
	GList *tlist;
	camera the_camera;
	light the_light;
	light *lightp;
	object the_object;
	polygon the_polygon;
	vertex v1, v2, v3, v4, v5;
	float temp;
	void *temp_vp;
	
	char ddata[] = "I'm debugging!\n";
	char identstr[100];
	void *junk = NULL;

	/* Test renderworld as a module */
	ggi3d_command(vis, mod_renderworld, CMD_GET_IDENT, junk, identstr);
	printf("identstr = %s\n", identstr);
	
	the_world.vis = vis;

	the_world.the_camera.x = 0.0;
	the_world.the_camera.y = 0.0;
	the_world.the_camera.z = -5.0;
	the_world.the_camera.t = 4.0;
	the_world.the_camera.p = 5.0;
	the_world.the_camera.a = 6.0;
	the_world.the_camera.nc = 7.0;
	the_world.the_camera.fc = 8.0;

	the_light.origin.x = 1.0;
	the_light.origin.y = 2.0;
	the_light.origin.z = 3.0;
	the_light.the_rgb.r = 0.0;
	the_light.the_rgb.g = 0.3;
	the_light.the_rgb.b = 1.0;
	
	the_world.light_list = NULL;

	the_world.light_list = g_list_alloc();
	g_list_append(the_world.light_list, &the_light);
	
	tlist = g_list_first(the_world.light_list);
	tlist->data = &the_light;
	lightp = (light *)(tlist->data);
	temp = lightp->the_rgb.g;
	
	v1.c.x = 100.0; v1.c.y = 300.0; v1.c.z = 0.0; v1.c.h = 0.0;
	v2.c.x = 300.0; v2.c.y = 300.0; v2.c.z = 0.0; v2.c.h = 0.0;
	v3.c.x = 400.0; v3.c.y = 100.0; v3.c.z = 0.0; v3.c.h = 0.0;
	v4.c.x = 300.0; v4.c.y = 0.0; v4.c.z = 0.0; v4.c.h = 0.0;
	v5.c.x = 100.0; v5.c.y = 100.0; v5.c.z = 0.0; v5.c.h = 0.0;

	tlist = g_list_alloc();
	tlist->data = &v1;
	tlist = g_list_append(tlist, &v1);
	tlist->data = &v2;
	tlist = g_list_append(tlist, &v2);
	tlist->data = &v3;
	tlist = g_list_append(tlist, &v3);
	tlist->data = &v4;
	tlist = g_list_append(tlist, &v4);
	tlist->data = &v5;
	tlist = g_list_append(tlist, &v5);
	tlist->data = &v5;
	
	the_polygon.vertex_list = tlist;
	
	the_object.type = OBJ_POLYGON;
	the_object.the_object = &the_polygon;
	
	the_world.object_list = g_list_alloc();
	tlist = g_list_append(the_world.object_list, &the_object);
	tlist->data=&the_object;
	
// 	ggi3d_command(vis, mod_renderworld, CMD_PROCESS, (void *)&the_world, junk);
}

void test_ggivis(void)
{
	line myline;
	ggi3d_interface iface;
	ggi3dfunc_interface ifunc;
	
	iface.type_in = GGI3D_TYPE_LINE;
	iface.type_out = GGI3D_TYPE_NULL;
	
	ggi3d_command(vis, mod_ggivis, CMD_GET_INTERFACE,
		      (void *)&iface, (void *)ifunc);
	
	printf("ifunc=%x\n", ifunc);

	if (ifunc == NULL)
	{
		printf("Error getting 'line' interface from mod_ggivis\n");
		return;
	}
	
	myline.x1 = 100;
	myline.y1 = 100;
	myline.x2 = 500;
	myline.y2 = 300;
	
	printf("pppppppppppppppp\n");
	ifunc(mod_ggivis, (void *)&myline, NULL);
}

void initialize()
{
	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize misc extension */
	if (ggi3DInit() != 0) {
		ggiPanic("Unable to initialize LibGGI 3D extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}
	
	/* Attach the misc extension to the visual */
	if (ggi3DAttach(vis) < 0) {
		ggiPanic("Unable to attach 3D extension to visual\n");
	}
}


int main(void)
{
	ggi_color col;
	ggi_mode mode;
	int temp, inc, width, height;

	initialize();

	/* Set foreground color to white */
	col.r = 0xffff;
	col.g = 0xffff;
	col.b = 0xffff;
	ggiSetGCForeground(vis, ggiMapColor(vis, &col));

	/* Check what mode we actually got */
	ggiGetMode(vis, &mode);
	width = mode.visible.x;
	height = mode.visible.y;
	
	/* Draw a bunch of lines... */
	inc = height/66;
	for (temp = 0; temp <= (height-inc); temp += inc) {
		ggiDrawLine(vis, 0, temp, width-1, height-temp);
	}

	/* ...and flush the screen */
	ggiFlush(vis);
	
	/* Do some GGI3D tests here */
	setup_all_modules();
	test_ggivis();
	ggiFlush(vis);
	
	while(!ggiKbhit(vis));

	/* Detach extension from visual */
	ggi3DDetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize GGI3D extension */
	ggi3DExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
