/* $Id: module.h,v 1.1.1.1 2001/04/21 16:55:05 cegger Exp $
 * GGI3d module layer
 * (c) 1998 Andreas Beck <becka@ggi-project.org> and Jon Taylor <taylorj@ggi-project.org>
 */

#ifndef _GGI3D_MODULE_H
#define _GGI3D_MODULE_H

#include <stdlib.h>
#include <stdarg.h>
#include <ggi/ggi.h>
#include <ggi3d/internal.h>

/*
 * The ideas here were stolen from the EvStack concept, that was developed
 * mainly be me and Jason McMullan for the GGI project 
 * (http://www.ggi-project.org).
 */
/*
 * And then re-stolen by me (Jon Taylor) for LibGGI3D.
 */

/* Every module instance creates such a control structure through which it
 * is referenced.
 */
typedef struct ggi3d_module *ggi3d_modp;

typedef struct ggi3d_module
{
	void (*destroy)(ggi3d_modp self);
	int (*flush)(ggi3d_modp self);
	int (*command)(ggi_visual_t vis, ggi3d_modp self, int command, void *data_in, void *data_out);
	struct ggi3d_dlhandle *hand;
	void *priv;
} ggi3d_module;

/* Instantiate a module from its class */
ggi3d_modp ggi3d_load_module(ggi_visual_t vis, const char *modname);

/*  Flush a module */
int ggi3d_flush(ggi3d_modp self);

/* Send a command to a module. Semantics are defined by the module */
int ggi3d_command(ggi_visual_t vis, ggi3d_modp self, int command, void *data_in, void *data_out);

#endif
