/*
 * LibGGI3D 
 * 
 * Global definitions
 * 
 * Copyright (C) 1998 Jon Taylor [taylorj@ggi-project.org]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _GGI3D_GLOBALS_H
#define _GGI3D_GLOBALS_H

#include <glib.h>
#include <meschach/matrix.h>
#include <ggi/ggi.h>

/*
** FIXME FIXME FIXME!
** 
** Module-specific stuff belongs in the module headers, not here!
*/

typedef struct 
{
	float x, y, z, t, p, a, nc, fc;
} camera;

/* 
** Administrative commands.  All LibGGI3D components must handle these commands. 
*/

#define CMD_GET_IDENT		1	/* Return a null-terminated ident string */
#define CMD_DEBUG_DUMP_IN	2	/* Return EOF-terminated formatted input dump */
#define CMD_FLUSH		3	/* Flush state */
#define CMD_GET_INTERFACE	4	/* Return an interface descriptor */

#define LIST_LIGHT 1
#define LIST_OBJECT 2
#define LIST_POLYGON 3

typedef struct
{
	float x, y, z, h;
} coord;

typedef struct
{
	int x1, y1, x2, y2;
	ggi_color color;
} line;

typedef struct
{
	int x1, y1, x2, y2;
	ggi_color color;
} box;

typedef struct
{
	int junk;
} texture;

typedef struct
{
	coord c;
	VEC normal;
	ggi_color color;
} vertex;

typedef struct
{
	ggi_color diffuse_rgb;
	ggi_color specular_rgb;
	ggi_color ambient_rgb;
	int glossiness;
	// Add texture
} material;

typedef struct
{
	GList *vertex_list;
	material the_material;
} polygon;

typedef struct
{
	float x, y, z, a;
} intersection;

typedef struct
{
	ggi_coord c1, c2, c3, c4;
} curve;

#define OBJ_ASSEMBLY 1
#define OBJ_POLYGON 2
#define OBJ_POLYHEDRON 3
#define OBJ_BEZIER_CURVE 4
#define OBJ_BEZIER_PATCH 5

typedef struct
{
	void *the_object;
	int type;
} object;

typedef struct
{
	GList *object_list;
} assembly;

typedef struct
{
	int subdivision_level;
	GArray *the_mesh;
	int render_mode;
} patch_descriptor;

typedef struct
{
	ggi_color the_rgb;
	coord origin;
	VEC orientation;
	float focus_factor;	// How quickly light intensity falls off away from the orientation vector
} light;

typedef struct
{
	int junk;
} attributes;

GList *the_ost; // The global object symbol table
GList *the_lst; // The global light table

typedef struct
{
	camera the_camera;	
	GList *light_list;
	GList *object_list;
	ggi_visual_t *vis;	// Render to this visual
} renderworld_input_t;

typedef struct
{
	GList *polygon_list;
	GList *light_list;
	ggi_visual_t *visual;
} zbuffer_input_t;

typedef struct
{
	GList *light_list;
	material *the_material;
	VEC normal;
} phong_light_input_t;

typedef struct
{
	GList *module_list;
} pipeline_input_t;

#define GGI3D_TARGET_GLIDE 1
#define GGI3D_TARGET_LIBGGI 2


#endif
