#ifndef _GGI_3D_INT_H
#define _GGI_3D_INT_H

#include <ggi/internal/internal.h>
#include <ggi3d/3d.h>

extern ggi_extid ggi3DID;

ggi3d_modp ggi3d_load_module(ggi_visual_t vis, const char *modname);
int ggi3d_handle_input(ggi_visual_t vis, ggi3d_modp self, void *data_in, void *data_out);
int ggi3d_command(ggi_visual_t vis, ggi3d_modp self, int command, void *data_in, void *data_out);

typedef struct ggi3d_ext
{
	ggi3d_modp (*ggi3d_load_module)(ggi_visual_t vis, const char *modname);
	int (*ggi3d_handle_input)(ggi_visual_t vis, ggi3d_modp self, void *data_in, void *data_out);
	int (*ggi3d_command)(ggi_visual_t vis, ggi3d_modp self, int command, void *data_in, void *data_out);
	
	/* This module's ggi3d_handle_input() function will be called on ggiFlush() */
	ggi3d_modp visualmod;
	
	int (*oldflush)(ggi_visual *vis, int x, int y, int w, int h, int tryFlag);
	
	void *priv;
	
}	ggi3dext;

#define LIBGGI_3DEXT(vis) ((ggi3dext *)LIBGGI_EXT(vis, ggi3DID))

#endif /* _GGI_3D_INT_H */
