/* $Id: dl.c,v 1.1.1.1 2001/04/21 16:55:06 cegger Exp $
******************************************************************************

   GGI3D module loading

   Copyright (C) 1999 Jon Taylor [jtaylor@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define GGI3D_DLINIT_SYM         "ggi3d_dlinit"

#include <ggi/gg.h>
#include <ggi3d/internal.h>
#include "config.h"

/* Open the dynamic libary requested
 */
ggi3d_dlhandle *_ggi3DLoadDL(const char *name)
{
	ggi3d_dlhandle hand, *hp;

	printf("_ggi3DLoadDL(\"%s\") called \n", name);

	hand.handle = ggMLoadModule(_ggi3dconfhandle, name, 0, 0);

	printf("hand.handle = %p\n", hand.handle);
	if (hand.handle == NULL) 
	  return NULL;

	hand.init = ggGetSymbolAddress(hand.handle, GGI3D_DLINIT_SYM);

	printf("hand.init = %p\n", hand.init);
	if (hand.init == NULL || (hp = (ggi3d_dlhandle *) malloc(sizeof(ggi3d_dlhandle))) == NULL) 
	{
		ggFreeModule(hand.handle);
		return NULL;
	}
	
	memcpy(hp, &hand, sizeof(ggi3d_dlhandle));

	return hp;
}

int _ggi3DCloseDL(ggi3d_dlhandle *hand) 
{
	ggFreeModule(hand->handle);
	return 0;
}
